/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.core.ResolvableType;

public class GsonMapper
implements JsonMapper {
    private final Gson gson;

    public GsonMapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> List<T> toList(String json, Class<T> type) {
        return (List)this.gson.fromJson(json, ResolvableType.forClassWithGenerics(ArrayList.class, (Class[])new Class[]{type}).getType());
    }

    @Override
    public <T> T toSingle(String json, Class<T> type) {
        return (T)this.gson.fromJson(json, type);
    }

    @Override
    public String toString(Object value) {
        return this.gson.toJson(value);
    }
}

