/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionScan;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionRegistrationEvent;
import org.springframework.cloud.function.context.catalog.FunctionUnregistrationEvent;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.core.FluxConsumer;
import org.springframework.cloud.function.core.FluxFunction;
import org.springframework.cloud.function.core.FluxSupplier;
import org.springframework.cloud.function.core.FluxToMonoFunction;
import org.springframework.cloud.function.core.IsolatedConsumer;
import org.springframework.cloud.function.core.IsolatedFunction;
import org.springframework.cloud.function.core.IsolatedSupplier;
import org.springframework.cloud.function.core.MonoToFluxFunction;
import org.springframework.cloud.function.json.GsonMapper;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@FunctionScan
@Configuration
@ConditionalOnMissingBean(value={FunctionCatalog.class})
public class ContextFunctionCatalogAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";
    @Autowired(required=false)
    private Map<String, Supplier<?>> suppliers = Collections.emptyMap();
    @Autowired(required=false)
    private Map<String, Function<?, ?>> functions = Collections.emptyMap();
    @Autowired(required=false)
    private Map<String, Consumer<?>> consumers = Collections.emptyMap();
    @Autowired(required=false)
    private Map<String, FunctionRegistration<?>> registrations = Collections.emptyMap();

    @Bean
    public FunctionRegistry functionCatalog(ContextFunctionRegistry processor) {
        processor.merge(this.registrations, this.consumers, this.suppliers, this.functions);
        return new BeanFactoryFunctionCatalog(processor);
    }

    @Bean
    public FunctionInspector functionInspector(ContextFunctionRegistry processor) {
        return new BeanFactoryFunctionInspector(processor);
    }

    private static class PreferGsonOrMissingJacksonCondition
    extends AnyNestedCondition {
        PreferGsonOrMissingJacksonCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={ObjectMapper.class})
        static class JacksonMissing {
            JacksonMissing() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="gson", matchIfMissing=false)
        static class GsonPreferred {
            GsonPreferred() {
            }
        }
    }

    @Component
    protected static class ContextFunctionRegistry {
        private Map<String, Object> suppliers = new ConcurrentHashMap<String, Object>();
        private Map<String, Object> functions = new ConcurrentHashMap<String, Object>();
        private Map<String, Object> consumers = new ConcurrentHashMap<String, Object>();
        @Autowired(required=false)
        private ApplicationEventPublisher publisher;
        @Autowired
        private ConfigurableListableBeanFactory registry;
        private Map<Object, String> names = new ConcurrentHashMap<Object, String>();
        private Map<String, FunctionType> types = new ConcurrentHashMap<String, FunctionType>();

        protected ContextFunctionRegistry() {
        }

        public Set<String> getSuppliers() {
            return this.suppliers.keySet();
        }

        public FunctionRegistration<?> getRegistration(Object function) {
            if (function == null || !this.names.containsKey(function)) {
                return null;
            }
            return new FunctionRegistration<Object>(function, this.names.get(function)).type(this.findType(function).getType());
        }

        public Set<String> getConsumers() {
            return this.consumers.keySet();
        }

        public Set<String> getFunctions() {
            return this.functions.keySet();
        }

        public Supplier<?> lookupSupplier(String name) {
            Object composed = this.compose(name, this.suppliers, false);
            if (composed instanceof Supplier) {
                return (Supplier)composed;
            }
            return null;
        }

        public Consumer<?> lookupConsumer(String name) {
            Object composed = this.compose(name, this.consumers, true);
            if (composed instanceof Consumer) {
                return (Consumer)composed;
            }
            return null;
        }

        public Function<?, ?> lookupFunction(String name) {
            Object composed = this.compose(name, this.functions, true);
            if (composed instanceof Function) {
                return (Function)composed;
            }
            return null;
        }

        private Object compose(String name, Map<String, Object> lookup, boolean hasInput) {
            Object function;
            Map<String, Object> source;
            if (lookup.containsKey(name = name.replaceAll(",", "|"))) {
                return lookup.get(name);
            }
            String[] stages = StringUtils.delimitedListToStringArray((String)name, (String)"|");
            Map<String, Object> map = source = !hasInput || stages.length <= 1 ? lookup : this.functions;
            if (stages.length == 0 && source.size() == 1) {
                stages = new String[]{source.keySet().iterator().next()};
            }
            Object object = function = stages.length > 0 ? this.lookup(stages[0], source) : null;
            if (function == null) {
                return null;
            }
            Object other = null;
            for (int i = 1; i < stages.length - 1; ++i) {
                other = this.lookup(stages[i], this.functions);
                if (other == null) {
                    return null;
                }
                function = this.compose(function, other);
            }
            if (stages.length > 1) {
                other = this.lookup(stages[stages.length - 1], hasInput ? lookup : this.functions);
                if (other == null) {
                    return null;
                }
                function = this.compose(function, other);
            }
            Object value = function;
            lookup.computeIfAbsent(name, key -> value);
            if (!this.types.containsKey(name) && this.types.containsKey(stages[0]) && this.types.containsKey(stages[stages.length - 1])) {
                FunctionType input = this.types.get(stages[0]);
                FunctionType output = this.types.get(stages[stages.length - 1]);
                this.types.put(name, FunctionType.compose(input, output));
            }
            this.names.put(function, name);
            return function;
        }

        private Object lookup(String name, Map<String, Object> lookup) {
            Object result = lookup.get(name);
            if (result != null) {
                this.findType(result);
            }
            return result;
        }

        private Object compose(Object a, Object b) {
            if (a instanceof Supplier && b instanceof Function) {
                Supplier supplier = (Supplier)a;
                if (b instanceof FluxConsumer) {
                    if (supplier instanceof FluxSupplier) {
                        FluxConsumer fConsumer = (FluxConsumer)b;
                        return () -> ContextFunctionRegistry.lambda$compose$2((Supplier)supplier, fConsumer);
                    }
                    throw new IllegalStateException("The provided supplier is finite (i.e., already composed with Consumer) therefore it can not be composed with another consumer");
                }
                Function function = (Function)b;
                return () -> ContextFunctionRegistry.lambda$compose$3(function, (Supplier)supplier);
            }
            if (a instanceof Function && b instanceof Function) {
                Function function1 = (Function)a;
                Function function2 = (Function)b;
                if (function1 instanceof FluxToMonoFunction) {
                    if (function2 instanceof MonoToFluxFunction) {
                        return function1.andThen(function2);
                    }
                    throw new IllegalStateException("The provided function is finite (i.e., returns Mono<?>) therefore it can *only* be composed with compatible function (i.e., Function<Mono, Flux>");
                }
                if (function2 instanceof FluxToMonoFunction) {
                    return new FluxToMonoFunction(((Function)a).andThen(((FluxToMonoFunction)b).getTarget()));
                }
                return function1.andThen(function2);
            }
            if (a instanceof Function && b instanceof Consumer) {
                Function function = (Function)a;
                Consumer consumer = (Consumer)b;
                return v -> consumer.accept(function.apply(v));
            }
            throw new IllegalArgumentException(String.format("Could not compose %s and %s", a.getClass(), b.getClass()));
        }

        public <T> void register(FunctionRegistration<T> function) {
            this.wrap(function, function.getNames().iterator().next());
        }

        @PreDestroy
        public void close() {
            if (this.publisher != null) {
                if (!this.functions.isEmpty()) {
                    this.publisher.publishEvent((ApplicationEvent)new FunctionUnregistrationEvent(this, Function.class, this.functions.keySet()));
                }
                if (!this.consumers.isEmpty()) {
                    this.publisher.publishEvent((ApplicationEvent)new FunctionUnregistrationEvent(this, Consumer.class, this.consumers.keySet()));
                }
                if (!this.suppliers.isEmpty()) {
                    this.publisher.publishEvent((ApplicationEvent)new FunctionUnregistrationEvent(this, Supplier.class, this.suppliers.keySet()));
                }
            }
        }

        public Set<FunctionRegistration<?>> merge(Map<String, FunctionRegistration<?>> initial, Map<String, Consumer<?>> consumers, Map<String, Supplier<?>> suppliers, Map<String, Function<?, ?>> functions) {
            HashSet registrations = new HashSet();
            HashMap targets = new HashMap();
            for (String key : initial.keySet()) {
                FunctionRegistration<?> registration2 = initial.get(key);
                if (registration2.getNames().isEmpty()) {
                    registration2.names(this.getAliases(key));
                }
                registrations.add(registration2);
                targets.put(registration2.getTarget(), key);
            }
            Stream.concat(consumers.entrySet().stream(), Stream.concat(suppliers.entrySet().stream(), functions.entrySet().stream())).forEach(entry -> {
                if (!targets.containsKey(entry.getValue())) {
                    FunctionRegistration target = new FunctionRegistration(entry.getValue(), this.getAliases((String)entry.getKey()).toArray(new String[0]));
                    targets.put(target.getTarget(), (String)entry.getKey());
                    registrations.add(target);
                }
            });
            registrations.forEach(registration -> this.wrap((FunctionRegistration<?>)registration, (String)targets.get(registration.getTarget())));
            return registrations;
        }

        private Collection<String> getAliases(String key) {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            String value = this.getQualifier(key);
            if (value.equals(key) && this.registry != null) {
                names.addAll(Arrays.asList(this.registry.getAliases(key)));
            }
            names.add(value);
            return names;
        }

        private void wrap(FunctionRegistration<?> registration, String key) {
            Class type;
            Object target = registration.getTarget();
            this.names.put(target, key);
            if (registration.getType() != null) {
                this.types.put(key, registration.getType());
            } else {
                registration.type(this.findType(target).getType());
            }
            registration = this.transform(registration);
            target = registration.getTarget();
            if (target instanceof Supplier) {
                type = Supplier.class;
                for (String name : registration.getNames()) {
                    this.suppliers.put(name, registration.getTarget());
                }
            } else if (target instanceof Consumer) {
                type = Consumer.class;
                for (String name : registration.getNames()) {
                    this.consumers.put(name, registration.getTarget());
                }
            } else if (target instanceof Function) {
                type = Function.class;
                for (String name : registration.getNames()) {
                    this.functions.put(name, registration.getTarget());
                }
            } else {
                return;
            }
            this.names.put(registration.getTarget(), key);
            if (this.publisher != null) {
                this.publisher.publishEvent((ApplicationEvent)new FunctionRegistrationEvent(registration.getTarget(), type, registration.getNames()));
            }
        }

        private FunctionRegistration<?> transform(FunctionRegistration<?> registration) {
            return this.fluxify(this.isolated(registration));
        }

        private FunctionRegistration<?> fluxify(FunctionRegistration<?> input) {
            FunctionRegistration<?> registration = input;
            Object target = registration.getTarget();
            FunctionType type = registration.getType();
            boolean flux = this.hasFluxTypes(type);
            if (!flux) {
                if (target instanceof Supplier) {
                    target = new FluxSupplier((Supplier)target);
                } else if (target instanceof Function) {
                    target = new FluxFunction((Function)target);
                } else if (target instanceof Consumer) {
                    target = new FluxConsumer((Consumer)target);
                }
                registration.target(target);
            }
            if (Mono.class.isAssignableFrom(type.getOutputWrapper())) {
                registration.target(new FluxToMonoFunction((Function)target));
            } else if (Mono.class.isAssignableFrom(type.getInputWrapper())) {
                registration.target(new MonoToFluxFunction((Function)target));
            }
            return registration;
        }

        private boolean hasFluxTypes(FunctionType type) {
            return type.isWrapper();
        }

        private FunctionRegistration<?> isolated(FunctionRegistration<?> input) {
            boolean isolated;
            FunctionRegistration<?> registration = input;
            Object target = registration.getTarget();
            boolean bl = isolated = this.getClass().getClassLoader() != target.getClass().getClassLoader();
            if (target instanceof Supplier) {
                if (isolated) {
                    target = new IsolatedSupplier((Supplier)target);
                }
            } else if (target instanceof Function) {
                if (isolated) {
                    target = new IsolatedFunction((Function)target);
                }
            } else if (target instanceof Consumer && isolated) {
                target = new IsolatedConsumer((Consumer)target);
            }
            registration.target(target);
            return registration;
        }

        private String getQualifier(String key) {
            StandardMethodMetadata metadata;
            Qualifier qualifier;
            BeanDefinition beanDefinition;
            Object source;
            if (this.registry != null && this.registry.containsBeanDefinition(key) && (source = (beanDefinition = this.registry.getBeanDefinition(key)).getSource()) instanceof StandardMethodMetadata && (qualifier = (Qualifier)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)(metadata = (StandardMethodMetadata)source).getIntrospectedMethod(), Qualifier.class)) != null && qualifier.value().length() > 0) {
                return qualifier.value();
            }
            return key;
        }

        private FunctionType findType(Object function) {
            String name = this.names.get(function);
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            FunctionType param = name == null || this.registry == null || !this.registry.containsBeanDefinition(name) ? (function != null ? new FunctionType(function.getClass()) : FunctionType.UNCLASSIFIED) : new FunctionType(FunctionContextUtils.findType(name, this.registry));
            this.types.computeIfAbsent(name, str -> param);
            return param;
        }

        private static /* synthetic */ Object lambda$compose$3(Function function, Supplier supplier) {
            return function.apply(supplier.get());
        }

        private static /* synthetic */ Mono lambda$compose$2(Supplier supplier, FluxConsumer fConsumer) {
            return Mono.from((Publisher)((Flux)supplier.get()).compose(arg_0 -> ContextFunctionRegistry.lambda$null$1(fConsumer, (Supplier)supplier, arg_0)));
        }

        private static /* synthetic */ Publisher lambda$null$1(FluxConsumer fConsumer, Supplier supplier, Flux v) {
            return fConsumer.apply((Flux)supplier.get());
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    protected static class JacksonConfiguration {
        protected JacksonConfiguration() {
        }

        @Bean
        public JacksonMapper jsonMapper(ObjectMapper mapper) {
            return new JacksonMapper(mapper);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Gson.class})
    @ConditionalOnBean(value={Gson.class})
    @Conditional(value={PreferGsonOrMissingJacksonCondition.class})
    protected static class GsonConfiguration {
        protected GsonConfiguration() {
        }

        @Bean
        public GsonMapper jsonMapper(Gson gson) {
            return new GsonMapper(gson);
        }
    }

    protected class BeanFactoryFunctionInspector
    implements FunctionInspector {
        private ContextFunctionRegistry processor;

        public BeanFactoryFunctionInspector(ContextFunctionRegistry processor) {
            this.processor = processor;
        }

        @Override
        public FunctionRegistration<?> getRegistration(Object function) {
            FunctionRegistration<?> registration = this.processor.getRegistration(function);
            return registration;
        }
    }

    protected static class BeanFactoryFunctionCatalog
    implements FunctionRegistry {
        private final ContextFunctionRegistry processor;

        @Override
        public <T> void register(FunctionRegistration<T> registration) {
            Assert.notEmpty(registration.getNames(), (String)"'registration' must contain at least one name before it is registered in catalog.");
            this.processor.register(registration);
        }

        @Override
        public <T> T lookup(Class<?> type, String name) {
            Function<?, ?> function = null;
            if (type == null) {
                function = this.processor.lookupFunction(name);
                if (function == null) {
                    function = this.processor.lookupConsumer(name);
                }
                if (function == null) {
                    function = this.processor.lookupSupplier(name);
                }
            } else if (Supplier.class.isAssignableFrom(type)) {
                function = this.processor.lookupSupplier(name);
            } else if (Consumer.class.isAssignableFrom(type)) {
                function = this.processor.lookupConsumer(name);
            } else if (Function.class.isAssignableFrom(type)) {
                function = this.processor.lookupFunction(name);
            }
            return (T)function;
        }

        @Override
        public Set<String> getNames(Class<?> type) {
            if (Supplier.class.isAssignableFrom(type)) {
                return this.processor.getSuppliers();
            }
            if (Consumer.class.isAssignableFrom(type)) {
                return this.processor.getConsumers();
            }
            if (Function.class.isAssignableFrom(type)) {
                return this.processor.getFunctions();
            }
            return Collections.emptySet();
        }

        @Override
        public int size() {
            return this.processor.getSuppliers().size() + this.processor.getFunctions().size() + this.processor.getConsumers().size();
        }

        public BeanFactoryFunctionCatalog(ContextFunctionRegistry processor) {
            this.processor = processor;
        }
    }
}

