/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionRegistrationEvent;
import org.springframework.cloud.function.context.catalog.MessageConsumer;
import org.springframework.cloud.function.context.catalog.MessageFunction;
import org.springframework.cloud.function.context.catalog.MessageSupplier;
import org.springframework.cloud.function.core.FluxConsumer;
import org.springframework.cloud.function.core.FluxSupplier;
import org.springframework.cloud.function.core.FluxToMonoFunction;
import org.springframework.cloud.function.core.IsolatedConsumer;
import org.springframework.cloud.function.core.IsolatedFunction;
import org.springframework.cloud.function.core.IsolatedSupplier;
import org.springframework.cloud.function.core.MonoToFluxFunction;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractComposableFunctionRegistry
implements FunctionRegistry,
FunctionInspector,
ApplicationEventPublisherAware,
EnvironmentAware {
    private final Map<String, Object> suppliers = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> functions = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> consumers = new ConcurrentHashMap<String, Object>();
    private final Map<Object, String> names = new ConcurrentHashMap<Object, String>();
    private final Map<String, FunctionType> types = new ConcurrentHashMap<String, FunctionType>();
    private Environment environment = new StandardEnvironment();
    protected ApplicationEventPublisher applicationEventPublisher;

    @Override
    public <T> T lookup(Class<?> type, String name) {
        String functionDefinitionName = !StringUtils.hasText((String)name) && this.environment.containsProperty("spring.cloud.function.definition") ? this.environment.getProperty("spring.cloud.function.definition") : name;
        return (T)this.doLookup(type, functionDefinitionName);
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        if (type == null) {
            return new HashSet<String>(this.getSupplierNames()){
                {
                    this.addAll(AbstractComposableFunctionRegistry.this.getConsumerNames());
                    this.addAll(AbstractComposableFunctionRegistry.this.getFunctionNames());
                }
            };
        }
        if (Supplier.class.isAssignableFrom(type)) {
            return this.getSupplierNames();
        }
        if (Consumer.class.isAssignableFrom(type)) {
            return this.getConsumerNames();
        }
        if (Function.class.isAssignableFrom(type)) {
            return this.getFunctionNames();
        }
        return Collections.emptySet();
    }

    public Set<String> getSupplierNames() {
        return this.suppliers.keySet();
    }

    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    public Set<String> getConsumerNames() {
        return this.consumers.keySet();
    }

    public boolean hasSuppliers() {
        return !CollectionUtils.isEmpty(this.getSupplierNames());
    }

    public boolean hasFunctions() {
        return !CollectionUtils.isEmpty(this.getFunctionNames());
    }

    public boolean hasConsumers() {
        return !CollectionUtils.isEmpty(this.getConsumerNames());
    }

    @Override
    public int size() {
        return this.getSupplierNames().size() + this.getFunctionNames().size() + this.getConsumerNames().size();
    }

    public FunctionType getFunctionType(String name) {
        return this.types.get(name);
    }

    public String lookupFunctionName(Object function) {
        return this.names.containsKey(function) ? this.names.get(function) : null;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        String functionName;
        String string = functionName = function == null ? null : this.lookupFunctionName(function);
        if (StringUtils.hasText((String)functionName)) {
            FunctionRegistration<Object> registration = new FunctionRegistration<Object>(function, functionName);
            FunctionType functionType = this.findType(registration);
            return registration.type(functionType.getType());
        }
        return null;
    }

    @Override
    public <T> void register(FunctionRegistration<T> functionRegistration) {
        Assert.notEmpty(functionRegistration.getNames(), (String)"'registration' must contain at least one name before it is registered in catalog.");
        this.register(functionRegistration, functionRegistration.getNames().iterator().next());
    }

    protected void register(FunctionRegistration<?> registration, String key) {
        Class type;
        Object target = registration.getTarget();
        this.addName(target, key);
        if (registration.getType() != null) {
            this.addType(key, registration.getType());
        } else {
            FunctionType functionType = this.findType(registration);
            this.addType(key, functionType);
            registration.type(functionType.getType());
        }
        registration = this.isolated(registration).wrap();
        target = registration.getTarget();
        if (target instanceof Supplier) {
            type = Supplier.class;
            for (String name : registration.getNames()) {
                this.addSupplier(name, (Supplier)registration.getTarget());
            }
        } else if (target instanceof Consumer) {
            type = Consumer.class;
            for (String name : registration.getNames()) {
                this.addConsumer(name, (Consumer)registration.getTarget());
            }
        } else if (target instanceof Function) {
            type = Function.class;
            for (String name : registration.getNames()) {
                this.addFunction(name, (Function)registration.getTarget());
            }
        } else {
            return;
        }
        this.addName(registration.getTarget(), key);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new FunctionRegistrationEvent(registration.getTarget(), type, registration.getNames()));
        }
    }

    protected FunctionType findType(FunctionRegistration<?> functionRegistration) {
        String name = this.lookupFunctionName(functionRegistration.getTarget());
        return functionRegistration.getType() != null ? functionRegistration.getType() : this.getFunctionType(name);
    }

    protected void addSupplier(String name, Supplier<?> supplier) {
        this.suppliers.put(name, supplier);
    }

    protected void addFunction(String name, Function<?, ?> function) {
        this.functions.put(name, function);
    }

    protected void addConsumer(String name, Consumer<?> consumer) {
        this.consumers.put(name, consumer);
    }

    protected void addType(String name, FunctionType functionType) {
        this.types.computeIfAbsent(name, str -> functionType);
    }

    protected void addName(Object function, String name) {
        this.names.put(function, name);
    }

    private FunctionRegistration<?> isolated(FunctionRegistration<?> input) {
        boolean isolated;
        FunctionRegistration<?> registration = input;
        Object target = registration.getTarget();
        boolean bl = isolated = this.getClass().getClassLoader() != target.getClass().getClassLoader();
        if (isolated) {
            if (target instanceof Supplier && isolated) {
                target = new IsolatedSupplier((Supplier)target);
            } else if (target instanceof Function) {
                target = new IsolatedFunction((Function)target);
            } else if (target instanceof Consumer) {
                target = new IsolatedConsumer((Consumer)target);
            }
        }
        registration.target(target);
        return registration;
    }

    private Object compose(String name, Map<String, Object> lookup) {
        name = name.replaceAll(",", "|").trim();
        Object composedFunction = null;
        if (lookup.containsKey(name)) {
            composedFunction = lookup.get(name);
        } else if (name.equals("") && lookup.size() == 1) {
            composedFunction = lookup.values().iterator().next();
        } else {
            String[] stages = StringUtils.delimitedListToStringArray((String)name, (String)"|");
            AtomicBoolean supplierPresent = new AtomicBoolean();
            List composableFunctions = Stream.of(stages).map(funcName -> this.find((String)funcName, supplierPresent.get())).filter(x -> x != null).peek(f -> supplierPresent.set(f.getTarget() instanceof Supplier)).collect(Collectors.toList());
            FunctionRegistration composedRegistration = composableFunctions.stream().reduce((a, z) -> this.composeFunctions((FunctionRegistration<?>)a, (FunctionRegistration<?>)z)).orElseGet(() -> null);
            if (composedRegistration != null && composedRegistration.getTarget() != null && !this.types.containsKey(name)) {
                composedFunction = composedRegistration.getTarget();
                this.addType(name, composedRegistration.getType());
                this.addName(composedFunction, name);
                if (composedFunction instanceof Function) {
                    this.addFunction(name, (Function)composedFunction);
                } else if (composedFunction instanceof Consumer) {
                    this.addConsumer(name, (Consumer)composedFunction);
                } else if (composedFunction instanceof Supplier) {
                    this.addSupplier(name, (Supplier)composedFunction);
                }
            }
        }
        return composedFunction;
    }

    private FunctionRegistration<?> find(String name, boolean supplierFound) {
        Object result = this.suppliers.get(name);
        if (result == null) {
            result = this.functions.get(name);
        }
        if (result == null) {
            result = this.consumers.get(name);
        }
        if (result == null && !StringUtils.hasText((String)name)) {
            if (supplierFound && this.functions.size() == 1) {
                result = this.functions.values().iterator().next();
            } else if (!supplierFound && this.suppliers.size() == 1) {
                result = this.suppliers.values().iterator().next();
            }
        }
        return this.getRegistration(result);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FunctionRegistration<?> composeFunctions(FunctionRegistration<?> aReg, FunctionRegistration<?> bReg) {
        void var7_16;
        FunctionType aType = aReg.getType();
        FunctionType bType = bReg.getType();
        Object a = aReg.getTarget();
        Object b = bReg.getTarget();
        if (aType != null && bType != null && aType.isMessage() && !bType.isMessage()) {
            bType = bType.message();
            b = this.message(b);
        }
        Object var7_7 = null;
        if (a instanceof Supplier && b instanceof Function) {
            Supplier supplier = (Supplier)a;
            if (b instanceof FluxConsumer) {
                if (!(supplier instanceof FluxSupplier)) throw new IllegalStateException("The provided supplier is finite (i.e., already composed with Consumer) therefore it can not be composed with another consumer");
                FluxConsumer fConsumer = (FluxConsumer)b;
                Supplier<Mono> supplier2 = () -> AbstractComposableFunctionRegistry.lambda$composeFunctions$7((Supplier)supplier, fConsumer);
            } else {
                Function function = (Function)b;
                Supplier<Object> supplier3 = () -> AbstractComposableFunctionRegistry.lambda$composeFunctions$8(function, (Supplier)supplier);
            }
        } else if (a instanceof Function && b instanceof Function) {
            Function function1 = (Function)a;
            Function function2 = (Function)b;
            if (function1 instanceof FluxToMonoFunction) {
                if (!(function2 instanceof MonoToFluxFunction)) throw new IllegalStateException("The provided function is finite (i.e., returns Mono<?>) therefore it can *only* be composed with compatible function (i.e., Function<Mono, Flux>");
                Function function = function1.andThen(function2);
            } else if (function2 instanceof FluxToMonoFunction) {
                FluxToMonoFunction fluxToMonoFunction = new FluxToMonoFunction(((Function)a).andThen((Function)((FluxToMonoFunction)b).getTarget()));
            } else {
                Function function = function1.andThen(function2);
            }
        } else {
            if (!(a instanceof Function) || !(b instanceof Consumer)) throw new IllegalArgumentException(String.format("Could not compose %s and %s", a.getClass(), b.getClass()));
            Function function = (Function)a;
            Consumer consumer = (Consumer)b;
            Consumer<Object> consumer2 = v -> consumer.accept(function.apply(v));
        }
        String name = aReg.getNames().iterator().next() + "|" + bReg.getNames().iterator().next();
        return new FunctionRegistration<void>(var7_16, name).type(FunctionType.compose(aType, bType));
    }

    private Object message(Object input) {
        if (input instanceof Supplier) {
            return new MessageSupplier((Supplier)input);
        }
        if (input instanceof Consumer) {
            return new MessageConsumer((Consumer)input);
        }
        if (input instanceof Function) {
            return new MessageFunction((Function)input);
        }
        return input;
    }

    private Object doLookup(Class<?> type, String name) {
        Object composed;
        Object function = null;
        if (type == null) {
            function = this.compose(name, this.functions);
            if (function == null) {
                function = this.compose(name, this.consumers);
            }
            if (function == null) {
                function = this.compose(name, this.suppliers);
            }
        } else if (Function.class.isAssignableFrom(type)) {
            Object composed2 = this.compose(name, this.functions);
            if (composed2 != null && Function.class.isAssignableFrom(composed2.getClass())) {
                function = composed2;
            }
        } else if (Supplier.class.isAssignableFrom(type)) {
            Object composed3 = this.compose(name, this.suppliers);
            if (composed3 != null && Supplier.class.isAssignableFrom(composed3.getClass())) {
                function = composed3;
            }
        } else if (Consumer.class.isAssignableFrom(type) && (composed = this.compose(name, this.consumers)) != null && Consumer.class.isAssignableFrom(composed.getClass())) {
            function = composed;
        }
        return function;
    }

    private static /* synthetic */ Object lambda$composeFunctions$8(Function function, Supplier supplier) {
        return function.apply(supplier.get());
    }

    private static /* synthetic */ Mono lambda$composeFunctions$7(Supplier supplier, FluxConsumer fConsumer) {
        return Mono.from((Publisher)((Flux)supplier.get()).compose(arg_0 -> AbstractComposableFunctionRegistry.lambda$null$6(fConsumer, (Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ Publisher lambda$null$6(FluxConsumer fConsumer, Supplier supplier, Flux v) {
        return fConsumer.apply((Flux)supplier.get());
    }
}

