/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.AbstractComposableFunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionUnregistrationEvent;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.json.GsonMapper;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;

@Configuration
@ConditionalOnMissingBean(value={FunctionCatalog.class})
@ComponentScan(basePackages={"${spring.cloud.function.scan.packages:functions}"}, includeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={Supplier.class, Function.class, Consumer.class})})
public class ContextFunctionCatalogAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";

    @Bean
    public FunctionRegistry functionCatalog() {
        return new BeanFactoryFunctionCatalog();
    }

    @Bean(value={"router"})
    @ConditionalOnProperty(name={"spring.cloud.function.routing.enabled"}, havingValue="true")
    RoutingFunction gateway(FunctionCatalog functionCatalog, FunctionInspector functionInspector) {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new MappingJackson2MessageConverter());
        messageConverters.add(new StringMessageConverter());
        messageConverters.add(new ByteArrayMessageConverter());
        CompositeMessageConverter messageConverter = new CompositeMessageConverter(messageConverters);
        return new RoutingFunction(functionCatalog, functionInspector, (MessageConverter)messageConverter);
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    protected static class JacksonConfiguration {
        protected JacksonConfiguration() {
        }

        @Bean
        public JacksonMapper jsonMapper(ObjectMapper mapper) {
            return new JacksonMapper(mapper);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Gson.class})
    @ConditionalOnBean(value={Gson.class})
    @Conditional(value={PreferGsonOrMissingJacksonCondition.class})
    protected static class GsonConfiguration {
        protected GsonConfiguration() {
        }

        @Bean
        public GsonMapper jsonMapper(Gson gson) {
            return new GsonMapper(gson);
        }
    }

    private static class PreferGsonOrMissingJacksonCondition
    extends AnyNestedCondition {
        PreferGsonOrMissingJacksonCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={ObjectMapper.class})
        static class JacksonMissing {
            JacksonMissing() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="gson", matchIfMissing=false)
        static class GsonPreferred {
            GsonPreferred() {
            }
        }
    }

    protected static class BeanFactoryFunctionCatalog
    extends AbstractComposableFunctionRegistry
    implements SmartInitializingSingleton,
    BeanFactoryAware {
        private ApplicationEventPublisher applicationEventPublisher;
        private ConfigurableListableBeanFactory beanFactory;

        protected BeanFactoryFunctionCatalog() {
        }

        public void afterSingletonsInstantiated() {
            Map supplierBeans = this.beanFactory.getBeansOfType(Supplier.class);
            Map functionBeans = this.beanFactory.getBeansOfType(Function.class);
            Map consumerBeans = this.beanFactory.getBeansOfType(Consumer.class);
            Map functionRegistrationBeans = this.beanFactory.getBeansOfType(FunctionRegistration.class);
            this.doMerge(functionRegistrationBeans, consumerBeans, supplierBeans, functionBeans);
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        @PreDestroy
        public void close() {
            if (this.applicationEventPublisher != null) {
                if (this.hasFunctions()) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new FunctionUnregistrationEvent(this, Function.class, this.getFunctionNames()));
                }
                if (this.hasSuppliers()) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new FunctionUnregistrationEvent(this, Supplier.class, this.getSupplierNames()));
                }
            }
        }

        @Override
        protected FunctionType findType(FunctionRegistration<?> functionRegistration, String name) {
            FunctionType functionType = super.findType(functionRegistration, name);
            if (functionType == null) {
                functionType = this.functionByNameExist(name) ? new FunctionType(functionRegistration.getTarget().getClass()) : new FunctionType(FunctionContextUtils.findType(name, this.beanFactory));
            }
            return functionType;
        }

        @Deprecated
        Set<FunctionRegistration<?>> merge(Map<String, FunctionRegistration> initial, Map<String, Consumer> consumers, Map<String, Supplier> suppliers, Map<String, Function> functions) {
            this.doMerge(initial, consumers, suppliers, functions);
            return null;
        }

        private Collection<String> getAliases(String key) {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            String value = this.getQualifier(key);
            if (value.equals(key) && this.beanFactory != null) {
                names.addAll(Arrays.asList(this.beanFactory.getAliases(key)));
            }
            names.add(value);
            return names;
        }

        private String getQualifier(String key) {
            StandardMethodMetadata metadata;
            Qualifier qualifier;
            BeanDefinition beanDefinition;
            Object source;
            if (this.beanFactory != null && this.beanFactory.containsBeanDefinition(key) && (source = (beanDefinition = this.beanFactory.getBeanDefinition(key)).getSource()) instanceof StandardMethodMetadata && (qualifier = (Qualifier)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)(metadata = (StandardMethodMetadata)source).getIntrospectedMethod(), Qualifier.class)) != null && qualifier.value().length() > 0) {
                return qualifier.value();
            }
            return key;
        }

        private boolean functionByNameExist(String name) {
            return name == null || this.beanFactory == null || !this.beanFactory.containsBeanDefinition(name);
        }

        private void doMerge(Map<String, FunctionRegistration> functionRegistrationBeans, Map<String, Consumer> consumerBeans, Map<String, Supplier> supplierBeans, Map<String, Function> functionBeans) {
            HashSet<FunctionRegistration> registrations = new HashSet<FunctionRegistration>();
            HashMap targets = new HashMap();
            for (String key : functionRegistrationBeans.keySet()) {
                FunctionRegistration registration2 = functionRegistrationBeans.get(key);
                if (registration2.getNames().isEmpty()) {
                    registration2.names(this.getAliases(key));
                }
                registrations.add(registration2);
                targets.put(registration2.getTarget(), key);
            }
            Stream.concat(consumerBeans.entrySet().stream(), Stream.concat(supplierBeans.entrySet().stream(), functionBeans.entrySet().stream())).forEach(entry -> {
                if (!targets.containsKey(entry.getValue())) {
                    FunctionRegistration target = new FunctionRegistration(entry.getValue(), this.getAliases((String)entry.getKey()).toArray(new String[0]));
                    targets.put(target.getTarget(), (String)entry.getKey());
                    registrations.add(target);
                }
            });
            registrations.forEach(registration -> this.register((FunctionRegistration<?>)registration, (String)targets.get(registration.getTarget())));
        }
    }
}

