/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.integration.dsl;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.integration.dsl.FunctionFlowDefinition;
import org.springframework.cloud.function.integration.dsl.FunctionLookupHelper;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.GatewayProxySpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.MessageChannelSpec;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class FunctionFlowBuilder {
    private final FunctionLookupHelper functionLookupHelper;

    public FunctionFlowBuilder(FunctionCatalog functionCatalog) {
        Assert.notNull((Object)functionCatalog, (String)"'functionCatalog' must not be null");
        this.functionLookupHelper = new FunctionLookupHelper(functionCatalog);
    }

    public FunctionFlowDefinition fromSupplier(String supplierDefinition) {
        return this.fromSupplier(supplierDefinition, null);
    }

    public FunctionFlowDefinition fromSupplier(String supplierDefinition, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return this.fromSupplier(this.functionLookupHelper.lookupSupplier(supplierDefinition), endpointConfigurer);
    }

    public <T> FunctionFlowDefinition fromSupplier(Supplier<T> messageSource) {
        return this.fromSupplier(messageSource, null);
    }

    public <T> FunctionFlowDefinition fromSupplier(Supplier<T> messageSource, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return this.toFunctionFlow(IntegrationFlow.fromSupplier(messageSource, endpointConfigurer));
    }

    public FunctionFlowDefinition from(MessageChannel messageChannel) {
        return this.toFunctionFlow(IntegrationFlow.from((MessageChannel)messageChannel));
    }

    public FunctionFlowDefinition from(String messageChannelName) {
        return this.from(messageChannelName, false);
    }

    public FunctionFlowDefinition from(String messageChannelName, boolean fixedSubscriber) {
        return this.toFunctionFlow(IntegrationFlow.from((String)messageChannelName, (boolean)fixedSubscriber));
    }

    public FunctionFlowDefinition from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return this.toFunctionFlow(IntegrationFlow.from(messageSourceSpec, endpointConfigurer));
    }

    public FunctionFlowDefinition from(MessageSource<?> messageSource) {
        return this.from(messageSource, null);
    }

    public FunctionFlowDefinition from(MessageSource<?> messageSource, @Nullable Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return this.toFunctionFlow(IntegrationFlow.from(messageSource, endpointConfigurer));
    }

    public FunctionFlowDefinition from(MessageProducerSupport messageProducer) {
        return this.toFunctionFlow(IntegrationFlow.from((MessageProducerSupport)messageProducer));
    }

    public FunctionFlowDefinition from(MessagingGatewaySupport inboundGateway) {
        return this.toFunctionFlow(IntegrationFlow.from((MessagingGatewaySupport)inboundGateway));
    }

    public FunctionFlowDefinition from(MessageChannelSpec<?, ?> messageChannelSpec) {
        return this.toFunctionFlow(IntegrationFlow.from(messageChannelSpec));
    }

    public FunctionFlowDefinition from(MessageProducerSpec<?, ?> messageProducerSpec) {
        return this.toFunctionFlow(IntegrationFlow.from(messageProducerSpec));
    }

    public FunctionFlowDefinition from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec) {
        return this.toFunctionFlow(IntegrationFlow.from(messageSourceSpec));
    }

    public FunctionFlowDefinition from(MessagingGatewaySpec<?, ?> inboundGatewaySpec) {
        return this.toFunctionFlow(IntegrationFlow.from(inboundGatewaySpec));
    }

    public FunctionFlowDefinition from(Class<?> serviceInterface) {
        return this.from(serviceInterface, null);
    }

    public FunctionFlowDefinition from(Class<?> serviceInterface, @Nullable Consumer<GatewayProxySpec> endpointConfigurer) {
        return this.toFunctionFlow(IntegrationFlow.from(serviceInterface, endpointConfigurer));
    }

    public FunctionFlowDefinition from(Publisher<? extends Message<?>> publisher) {
        return this.toFunctionFlow(IntegrationFlow.from(publisher));
    }

    private FunctionFlowDefinition toFunctionFlow(IntegrationFlowBuilder from) {
        FunctionFlowDefinition functionFlow = new FunctionFlowDefinition(this.functionLookupHelper);
        from.channel(functionFlow.getInputChannel());
        functionFlow.addUpstreamComponents(from.get().getIntegrationComponents());
        return functionFlow;
    }
}

