/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebApplicationContext;
import org.springframework.cloud.function.serverless.web.ProxyFilterRegistration;
import org.springframework.cloud.function.serverless.web.ProxyHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ProxyHttpServletResponse;
import org.springframework.cloud.function.serverless.web.ProxyServletContext;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class ProxyMvc {
    private static Log LOG = LogFactory.getLog(ProxyMvc.class);
    static final String MVC_RESULT_ATTRIBUTE = ProxyMvc.class.getName().concat(".MVC_RESULT_ATTRIBUTE");
    private final DispatcherServlet dispatcher;
    private final ConfigurableWebApplicationContext applicationContext;
    private ServletContext servletContext;

    public ConfigurableWebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public static ProxyMvc INSTANCE(ConfigurableWebApplicationContext applpicationContext) {
        return new ProxyMvc(applpicationContext);
    }

    public static ProxyMvc INSTANCE(Class<?> ... componentClasses) {
        AnnotationConfigServletWebApplicationContext applpicationContext = new AnnotationConfigServletWebApplicationContext();
        applpicationContext.scan(new String[]{componentClasses[0].getPackageName()});
        return ProxyMvc.INSTANCE((ConfigurableWebApplicationContext)applpicationContext);
    }

    ProxyMvc(ConfigurableWebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        ProxyServletContext servletContext = new ProxyServletContext();
        this.applicationContext.setServletContext((ServletContext)servletContext);
        this.dispatcher = new DispatcherServlet((WebApplicationContext)this.applicationContext);
        this.dispatcher.setDetectAllHandlerMappings(false);
        ServletRegistration.Dynamic reg = servletContext.addServlet("dispatcherServlet", (Servlet)this.dispatcher);
        reg.setLoadOnStartup(1);
        this.servletContext = applicationContext.getServletContext();
        try {
            this.dispatcher.init((ServletConfig)new ProxyServletConfig(this.servletContext));
            try {
                this.service(new ProxyHttpServletRequest(servletContext, "INFO", "/"), new ProxyHttpServletResponse());
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw new IllegalStateException("Faild to create Spring MVC DispatcherServlet proxy", e);
        }
    }

    public void stop() {
        this.applicationContext.stop();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.service(request, response, null);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, CountDownLatch latch) throws Exception {
        ProxyFilterChain filterChain = new ProxyFilterChain(this.dispatcher);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (latch != null) {
            latch.countDown();
        }
    }

    private static class ProxyServletConfig
    implements ServletConfig {
        private final ServletContext servletContext;

        ProxyServletConfig(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return "spring-serverless-proxy";
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new ArrayList());
        }

        public String getInitParameter(String name) {
            return null;
        }
    }

    private static class ProxyFilterChain
    implements FilterChain {
        @Nullable
        private ServletRequest request;
        @Nullable
        private ServletResponse response;
        private final List<Filter> filters;
        @Nullable
        private Iterator<Filter> iterator;

        ProxyFilterChain(DispatcherServlet servlet) {
            ArrayList filters = new ArrayList();
            servlet.getServletContext().getFilterRegistrations().values().forEach(fr -> filters.add(((ProxyFilterRegistration)fr).getFilter()));
            servlet.getWebApplicationContext().getBeansOfType(Filter.class).values().forEach(f -> filters.add(f));
            Assert.notNull(filters, (String)"filters cannot be null");
            Assert.noNullElements(filters, (String)"filters cannot contain null values");
            this.filters = ProxyFilterChain.initFilterList((Servlet)servlet, filters.toArray(new Filter[0]));
        }

        private static List<Filter> initFilterList(Servlet servlet, Filter ... filters) {
            Filter[] allFilters = (Filter[])ObjectUtils.addObjectToArray((Object[])filters, (Object)new ServletFilterProxy(servlet));
            return Arrays.asList(allFilters);
        }

        @Nullable
        public ServletRequest getRequest() {
            return this.request;
        }

        @Nullable
        public ServletResponse getResponse() {
            return this.response;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Assert.notNull((Object)request, (String)"Request must not be null");
            Assert.notNull((Object)response, (String)"Response must not be null");
            Assert.state((this.request == null ? 1 : 0) != 0, (String)"This FilterChain has already been called!");
            if (this.iterator == null) {
                this.iterator = this.filters.iterator();
            }
            if (this.iterator.hasNext()) {
                Filter nextFilter = this.iterator.next();
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
            this.request = request;
            this.response = response;
        }

        private static final class ServletFilterProxy
        implements Filter {
            private final Servlet delegateServlet;

            private ServletFilterProxy(Servlet servlet) {
                Assert.notNull((Object)servlet, (String)"servlet cannot be null");
                this.delegateServlet = servlet;
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                try {
                    if (((HttpServletResponse)response).getStatus() != HttpStatus.OK.value() && request instanceof ProxyHttpServletRequest) {
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)((HttpServletResponse)response).getStatus());
                        this.setErrorMessageAttribute((ProxyHttpServletRequest)request, (ProxyHttpServletResponse)response, null);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                        ((ProxyHttpServletRequest)request).setRequestURI("/error");
                        this.delegateServlet.service(request, response);
                    } else {
                        this.delegateServlet.service(request, response);
                        if (((HttpServletResponse)response).getStatus() != HttpStatus.OK.value() && request instanceof ProxyHttpServletRequest) {
                            ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)((HttpServletResponse)response).getStatus());
                            this.setErrorMessageAttribute((ProxyHttpServletRequest)request, (ProxyHttpServletResponse)response, null);
                            ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                            ((ProxyHttpServletRequest)request).setRequestURI("/error");
                            this.delegateServlet.service(request, response);
                        }
                    }
                }
                catch (Exception e) {
                    if (request instanceof ProxyHttpServletRequest) {
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                        this.setErrorMessageAttribute((ProxyHttpServletRequest)request, (ProxyHttpServletResponse)response, e);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.exception_type", (Object)e);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                        ((ProxyHttpServletRequest)request).setRequestURI("/error");
                    }
                    LOG.error((Object)("Failed processing the request to: " + ((HttpServletRequest)request).getRequestURI()), (Throwable)e);
                    this.delegateServlet.service(request, response);
                }
            }

            private void setErrorMessageAttribute(ProxyHttpServletRequest request, ProxyHttpServletResponse response, Exception exception) {
                if (exception != null && StringUtils.hasText((String)exception.getMessage())) {
                    request.setAttribute("jakarta.servlet.error.message", exception.getMessage());
                } else if (StringUtils.hasText((String)response.getErrorMessage())) {
                    request.setAttribute("jakarta.servlet.error.message", response.getErrorMessage());
                } else {
                    request.setAttribute("jakarta.servlet.error.message", HttpStatus.valueOf((int)response.getStatus()).getReasonPhrase());
                }
            }

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void destroy() {
            }

            public String toString() {
                return this.delegateServlet.toString();
            }
        }
    }
}

