/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.ArrayList;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.web.flux.FunctionController;
import org.springframework.cloud.function.web.flux.FunctionHandlerMapping;
import org.springframework.cloud.function.web.flux.StringConverter;
import org.springframework.cloud.function.web.flux.request.FluxHandlerMethodArgumentResolver;
import org.springframework.cloud.function.web.flux.response.FluxReturnValueHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Flux.class, AsyncHandlerMethodReturnValueHandler.class})
@Import(value={FunctionController.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, GsonAutoConfiguration.class})
public class ReactorAutoConfiguration {
    @Autowired
    private ApplicationContext context;

    @Bean
    public FunctionHandlerMapping functionHandlerMapping(FunctionCatalog catalog, FunctionController controller) {
        return new FunctionHandlerMapping(catalog, controller);
    }

    @Bean
    @ConditionalOnMissingBean
    public StringConverter functionStringConverter(FunctionInspector inspector, ConfigurableListableBeanFactory beanFactory) {
        return new BasicStringConverter(inspector, beanFactory);
    }

    @Bean
    public SmartInitializingSingleton fluxRequestMappingHandlerAdapterProcessor(final RequestMappingHandlerAdapter adapter, final FluxHandlerMethodArgumentResolver resolver) {
        return new SmartInitializingSingleton(){

            public void afterSingletonsInstantiated() {
                ArrayList<FluxHandlerMethodArgumentResolver> resolvers = new ArrayList<FluxHandlerMethodArgumentResolver>(adapter.getArgumentResolvers());
                resolvers.add(0, resolver);
                adapter.setArgumentResolvers(resolvers);
                if (!ClassUtils.isPresent((String)"org.springframework.core.ReactiveAdapter", null)) {
                    ArrayList<Object> handlers = new ArrayList<Object>(adapter.getReturnValueHandlers());
                    handlers.add(0, ReactorAutoConfiguration.this.context.getBean(FluxReturnValueHandler.class));
                    adapter.setReturnValueHandlers(handlers);
                }
            }
        };
    }

    private static class BasicStringConverter
    implements StringConverter {
        private ConversionService conversionService;
        private ConfigurableListableBeanFactory registry;
        private FunctionInspector inspector;

        public BasicStringConverter(FunctionInspector inspector, ConfigurableListableBeanFactory registry) {
            this.inspector = inspector;
            this.registry = registry;
        }

        @Override
        public Object convert(Object function, String value) {
            Class type;
            if (this.conversionService == null && this.registry != null) {
                ConversionService conversionService = this.registry.getConversionService();
                this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
            }
            return this.conversionService.canConvert(String.class, type = this.inspector.getInputType(function)) ? this.conversionService.convert((Object)value, type) : value;
        }
    }

    @Configuration
    protected static class FluxArgumentResolverConfiguration {
        protected FluxArgumentResolverConfiguration() {
        }

        @Bean
        public FluxHandlerMethodArgumentResolver fluxHandlerMethodArgumentResolver(FunctionInspector inspector, JsonMapper mapper) {
            return new FluxHandlerMethodArgumentResolver(inspector, mapper);
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.core.ReactiveAdapter"})
    protected static class FluxReturnValueConfiguration {
        protected FluxReturnValueConfiguration() {
        }

        @Bean
        public FluxReturnValueHandler fluxReturnValueHandler(FunctionInspector inspector, HttpMessageConverters converters) {
            return new FluxReturnValueHandler(inspector, converters.getConverters());
        }
    }
}

