/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux.response;

import org.reactivestreams.Publisher;
import org.springframework.cloud.function.web.flux.response.ResponseBodyEmitterSubscriber;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

class FluxResponseBodyEmitter
extends ResponseBodyEmitter {
    private final MediaType mediaType;
    private ResponseBodyEmitterSubscriber subscriber;

    public FluxResponseBodyEmitter(Publisher<?> observable) {
        this(new HttpHeaders(), null, observable);
    }

    public FluxResponseBodyEmitter(HttpHeaders request, MediaType mediaType, Publisher<?> observable) {
        this.mediaType = mediaType;
        this.subscriber = new ResponseBodyEmitterSubscriber(request, mediaType, observable, this, MediaType.APPLICATION_JSON.isCompatibleWith(mediaType));
    }

    protected void extendResponse(ServerHttpResponse outputMessage) {
        super.extendResponse(outputMessage);
        this.subscriber.extendResponse(outputMessage);
        HttpHeaders headers = outputMessage.getHeaders();
        if (headers.getContentType() == null && this.mediaType != null && !MediaType.ALL.equals((Object)this.mediaType)) {
            headers.setContentType(this.mediaType);
        }
    }
}

