/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class FormFilter
implements Filter,
Ordered {
    public static final int FORM_FILTER_ORDER = 9901;
    private static final Log log = LogFactory.getLog(FormFilter.class);
    private int order = 9901;
    private static final Charset FORM_CHARSET = StandardCharsets.UTF_8;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (FormFilter.isFormPost(req)) {
            HttpServletRequest wrapped = FormFilter.getRequestWithBodyFromRequestParameters(req);
            chain.doFilter((ServletRequest)wrapped, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    static boolean isFormPost(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && HttpMethod.POST.matches(request.getMethod());
    }

    static HttpServletRequest getRequestWithBodyFromRequestParameters(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, FORM_CHARSET);
        Map form = request.getParameterMap();
        String queryString = request.getQueryString();
        StringBuffer requestURL = request.getRequestURL();
        if (StringUtils.hasText((String)queryString)) {
            requestURL.append('?').append(queryString);
        }
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)requestURL.toString());
        MultiValueMap queryParams = uriComponentsBuilder.build().getQueryParams();
        Iterator entryIterator = form.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            String name = (String)entry.getKey();
            List<String> values = Arrays.asList((String[])entry.getValue());
            Iterator<String> valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                String value = valueIterator.next();
                List queryValues = (List)queryParams.get((Object)name);
                boolean isQueryParam = queryParams.containsKey((Object)name) && queryValues != null && queryValues.contains(value);
                if (isQueryParam) continue;
                writer.write(URLEncoder.encode(name, FORM_CHARSET));
                if (value == null) continue;
                ((Writer)writer).write(61);
                writer.write(URLEncoder.encode(value, FORM_CHARSET));
                if (!valueIterator.hasNext()) continue;
                ((Writer)writer).write(38);
            }
            if (!entryIterator.hasNext()) continue;
            writer.append('&');
        }
        ((Writer)writer).flush();
        final ByteArrayServletInputStream servletInputStream = new ByteArrayServletInputStream(new ByteArrayInputStream(bos.toByteArray()));
        return new FormContentRequestWrapper(request, queryParams){

            public ServletInputStream getInputStream() throws IOException {
                return servletInputStream;
            }
        };
    }

    private static class ByteArrayServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream body;

        ByteArrayServletInputStream(ByteArrayInputStream body) {
            body.reset();
            this.body = body;
        }

        public boolean isFinished() {
            return this.body.available() <= 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
        }

        public int read() {
            return this.body.read();
        }
    }

    private static class FormContentRequestWrapper
    extends HttpServletRequestWrapper {
        private final MultiValueMap<String, String> queryParams;

        FormContentRequestWrapper(HttpServletRequest request, MultiValueMap<String, String> params) {
            super(request);
            this.queryParams = params;
        }

        @Nullable
        public String getParameter(String name) {
            return (String)this.queryParams.getFirst((Object)name);
        }

        public Map<String, String[]> getParameterMap() {
            LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
            Enumeration<String> names = this.getParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                result.put(name, this.getParameterValues(name));
            }
            return result;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.queryParams.keySet());
        }

        @Nullable
        public String[] getParameterValues(String name) {
            return StringUtils.toStringArray((Collection)((Collection)this.queryParams.get((Object)name)));
        }
    }
}

