/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchangeHandlerFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class HandlerFunctions {
    private HandlerFunctions() {
    }

    public static HandlerFunction<ServerResponse> forward(String path) {
        return request -> GatewayServerResponse.ok().build((httpServletRequest, httpServletResponse) -> {
            try {
                String expandedFallback = MvcUtils.expand(request, path);
                request.servletRequest().getServletContext().getRequestDispatcher(expandedFallback).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return null;
            }
            catch (ServletException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static HandlerFunction<ServerResponse> http(String uri) {
        return HandlerFunctions.http(URI.create(uri));
    }

    public static HandlerFunction<ServerResponse> http(URI uri) {
        return new LookupProxyExchangeHandlerFunction(uri);
    }

    public static HandlerFunction<ServerResponse> https(URI uri) {
        return new LookupProxyExchangeHandlerFunction(uri);
    }

    public static HandlerFunction<ServerResponse> https() {
        return HandlerFunctions.http();
    }

    public static HandlerFunction<ServerResponse> http() {
        return new LookupProxyExchangeHandlerFunction();
    }

    static class LookupProxyExchangeHandlerFunction
    implements HandlerFunction<ServerResponse> {
        private final URI uri;
        private AtomicReference<ProxyExchangeHandlerFunction> proxyExchangeHandlerFunction = new AtomicReference();

        LookupProxyExchangeHandlerFunction() {
            this.uri = null;
        }

        LookupProxyExchangeHandlerFunction(URI uri) {
            this.uri = uri;
        }

        public ServerResponse handle(ServerRequest serverRequest) {
            if (this.uri != null) {
                serverRequest.attributes().put(MvcUtils.GATEWAY_REQUEST_URL_ATTR, this.uri);
            }
            this.proxyExchangeHandlerFunction.compareAndSet(null, LookupProxyExchangeHandlerFunction.lookup(serverRequest));
            return this.proxyExchangeHandlerFunction.get().handle(serverRequest);
        }

        private static ProxyExchangeHandlerFunction lookup(ServerRequest request) {
            return (ProxyExchangeHandlerFunction)MvcUtils.getApplicationContext(request).getBean(ProxyExchangeHandlerFunction.class);
        }

        public String toString() {
            ProxyExchangeHandlerFunction handlerFunction = this.proxyExchangeHandlerFunction.get();
            if (handlerFunction != null) {
                return handlerFunction.toString();
            }
            return ProxyExchangeHandlerFunction.class.getSimpleName();
        }
    }

    public static class HandlerSupplier
    implements org.springframework.cloud.gateway.server.mvc.handler.HandlerSupplier {
        @Override
        public Collection<Method> get() {
            return Arrays.asList(HandlerFunctions.class.getMethods());
        }
    }
}

