/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;

public class ProxyExchangeHandlerFunction
implements HandlerFunction<ServerResponse> {
    private static final Log log = LogFactory.getLog(ProxyExchangeHandlerFunction.class);
    private final ProxyExchange proxyExchange;
    private final ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters;
    private final ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters;
    private final URIResolver uriResolver;

    public ProxyExchangeHandlerFunction(ProxyExchange proxyExchange, ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters, ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters) {
        this(proxyExchange, requestHttpHeadersFilters, responseHttpHeadersFilters, request -> (URI)request.attribute(MvcUtils.GATEWAY_REQUEST_URL_ATTR).orElseThrow(() -> new IllegalStateException("No routeUri resolved")));
    }

    public ProxyExchangeHandlerFunction(ProxyExchange proxyExchange, ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters, ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters, URIResolver uriResolver) {
        this.proxyExchange = proxyExchange;
        this.requestHttpHeadersFilters = requestHttpHeadersFilters;
        this.responseHttpHeadersFilters = responseHttpHeadersFilters;
        this.uriResolver = uriResolver;
    }

    public ServerResponse handle(ServerRequest serverRequest) {
        URI uri = (URI)this.uriResolver.apply(serverRequest);
        boolean encoded = ProxyExchangeHandlerFunction.containsEncodedQuery(serverRequest.uri());
        URI url = UriComponentsBuilder.fromUri((URI)serverRequest.uri()).scheme(uri.getScheme()).host(uri.getHost()).port(uri.getPort()).replaceQueryParams(serverRequest.params()).build(encoded).toUri();
        HttpHeaders filteredRequestHeaders = this.filterHeaders(this.requestHttpHeadersFilters.orderedStream().map(Function.identity()), serverRequest.headers().asHttpHeaders(), serverRequest);
        boolean preserveHost = serverRequest.attributes().getOrDefault(MvcUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, false);
        if (preserveHost) {
            filteredRequestHeaders.set("Host", serverRequest.headers().firstHeader("Host"));
        } else {
            filteredRequestHeaders.remove((Object)"Host");
        }
        ProxyExchange.Request proxyRequest = this.proxyExchange.request(serverRequest).uri(url).headers(filteredRequestHeaders).responseConsumer((response, serverResponse) -> {
            HttpHeaders httpHeaders = this.filterHeaders(this.responseHttpHeadersFilters.orderedStream().map(Function.identity()), response.getHeaders(), serverResponse);
            serverResponse.headers().putAll((Map)httpHeaders);
        }).build();
        return this.proxyExchange.exchange(proxyRequest);
    }

    private <TYPE> HttpHeaders filterHeaders(Stream<HttpHeadersFilter<TYPE>> filters, HttpHeaders original, TYPE type) {
        HttpHeaders filtered = original;
        for (HttpHeadersFilter<TYPE> filter : filters.toList()) {
            filtered = (HttpHeaders)filter.apply(filtered, type);
        }
        return filtered;
    }

    private static boolean containsEncodedQuery(URI uri) {
        boolean encoded;
        boolean bl = encoded = uri.getRawQuery() != null && uri.getRawQuery().contains("%") || uri.getRawPath() != null && uri.getRawPath().contains("%");
        if (encoded) {
            try {
                UriComponentsBuilder.fromUri((URI)uri).build(true);
                return true;
            }
            catch (IllegalArgumentException ignored) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Error in containsEncodedParts", (Throwable)ignored);
                }
                return false;
            }
        }
        return encoded;
    }

    public static interface URIResolver
    extends Function<ServerRequest, URI> {
    }
}

