/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.common;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.gateway.server.mvc.common.ArgumentSupplier;
import org.springframework.cloud.gateway.server.mvc.common.AttributedArugmentSuppliedEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RequestPredicates;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;

public class ArgumentSupplierBeanPostProcessor
implements BeanPostProcessor {
    private final ApplicationEventPublisher publisher;

    public ArgumentSupplierBeanPostProcessor(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RouterFunction) {
            RouterFunction routerFunction = (RouterFunction)bean;
            PredicateVisitor predicateVisitor = new PredicateVisitor();
            RouterFunctionVisitor routerFunctionVisitor = new RouterFunctionVisitor(predicateVisitor);
            routerFunction.accept((RouterFunctions.Visitor)routerFunctionVisitor);
            if (predicateVisitor.argumentSupplier != null) {
                ArgumentSupplier.ArgumentSuppliedEvent argumentSuppliedEvent = predicateVisitor.argumentSupplier.getArgumentSuppliedEvent();
                if (predicateVisitor.attributes != null) {
                    argumentSuppliedEvent = new AttributedArugmentSuppliedEvent(argumentSuppliedEvent, predicateVisitor.attributes);
                }
                this.publisher.publishEvent(argumentSuppliedEvent);
            }
        }
        return bean;
    }

    class PredicateVisitor
    implements RequestPredicates.Visitor {
        private final AtomicReference<Map<String, Object>> attributesRef = new AtomicReference();
        private ArgumentSupplier argumentSupplier;
        private Map<String, Object> attributes;

        PredicateVisitor() {
        }

        public void unknown(RequestPredicate predicate) {
            if (predicate instanceof ArgumentSupplier) {
                ArgumentSupplier argumentSupplier;
                this.argumentSupplier = argumentSupplier = (ArgumentSupplier)predicate;
                this.attributes = this.attributesRef.get();
            }
        }

        public void method(Set<HttpMethod> methods) {
        }

        public void path(String pattern) {
        }

        public void pathExtension(String extension) {
        }

        public void header(String name, String value) {
        }

        public void param(String name, String value) {
        }

        public void startAnd() {
        }

        public void and() {
        }

        public void endAnd() {
        }

        public void startOr() {
        }

        public void or() {
        }

        public void endOr() {
        }

        public void startNegate() {
        }

        public void endNegate() {
        }
    }

    class RouterFunctionVisitor
    implements RouterFunctions.Visitor {
        private final PredicateVisitor predicateVisitor;

        RouterFunctionVisitor(PredicateVisitor predicateVisitor) {
            this.predicateVisitor = predicateVisitor;
        }

        public void route(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
            predicate.accept((RequestPredicates.Visitor)this.predicateVisitor);
        }

        public void attributes(Map<String, Object> attributes) {
            this.predicateVisitor.attributesRef.set(attributes);
        }

        public void startNested(RequestPredicate predicate) {
        }

        public void endNested(RequestPredicate predicate) {
        }

        public void resources(Function<ServerRequest, Optional<Resource>> lookupFunction) {
        }

        public void unknown(RouterFunction<?> routerFunction) {
        }
    }
}

