/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import com.google.cloud.logging.Severity;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.gcp.core.DefaultGcpProjectIdProvider;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.cloud.gcp.logging.StackdriverErrorReportingServiceContext;
import org.springframework.cloud.gcp.logging.StackdriverTraceConstants;
import org.springframework.cloud.gcp.logging.TraceIdLoggingEnhancer;
import org.springframework.util.StringUtils;

public class StackdriverJsonLayout
extends JsonLayout {
    private static final Set<String> FILTERED_MDC_FIELDS = new HashSet<String>(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-Span-Export"));
    private static final Map<Level, String> logbackToSeverityMap = new MapBuilder().put((Object)Level.TRACE, (Object)Severity.DEBUG.name()).put((Object)Level.DEBUG, (Object)Severity.DEBUG.name()).put((Object)Level.INFO, (Object)Severity.INFO.name()).put((Object)Level.WARN, (Object)Severity.WARNING.name()).put((Object)Level.ERROR, (Object)Severity.ERROR.name()).build();
    private String projectId;
    private boolean includeTraceId;
    private boolean includeSpanId;
    private boolean includeExceptionInMessage;
    private StackdriverErrorReportingServiceContext serviceContext;
    private Map<String, Object> customJson;

    public StackdriverJsonLayout() {
        this.appendLineSeparator = true;
        this.includeExceptionInMessage = true;
        this.includeException = false;
        this.includeTraceId = true;
        this.includeSpanId = true;
        Gson formatter = new Gson();
        this.setJsonFormatter(arg_0 -> ((Gson)formatter).toJson(arg_0));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean isIncludeTraceId() {
        return this.includeTraceId;
    }

    public void setIncludeTraceId(boolean includeTraceId) {
        this.includeTraceId = includeTraceId;
    }

    public boolean isIncludeSpanId() {
        return this.includeSpanId;
    }

    public void setIncludeSpanId(boolean includeSpanId) {
        this.includeSpanId = includeSpanId;
    }

    public boolean isIncludeExceptionInMessage() {
        return this.includeExceptionInMessage;
    }

    public void setIncludeExceptionInMessage(boolean includeExceptionInMessage) {
        this.includeExceptionInMessage = includeExceptionInMessage;
    }

    public void setServiceContext(StackdriverErrorReportingServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setCustomJson(String json) {
        Gson gson = new Gson();
        this.customJson = (Map)gson.fromJson(json, Map.class);
    }

    public void start() {
        super.start();
        if (StringUtils.isEmpty((Object)this.projectId) || this.projectId.endsWith("_IS_UNDEFINED")) {
            DefaultGcpProjectIdProvider projectIdProvider = new DefaultGcpProjectIdProvider();
            this.projectId = projectIdProvider.getProjectId();
        }
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.includeMDC) {
            event.getMDCPropertyMap().forEach((key, value) -> {
                if (!FILTERED_MDC_FIELDS.contains(key)) {
                    map.put((String)key, value);
                }
            });
        }
        if (this.includeTimestamp) {
            map.put("timestampSeconds", TimeUnit.MILLISECONDS.toSeconds(event.getTimeStamp()));
            map.put("timestampNanos", TimeUnit.MILLISECONDS.toNanos(event.getTimeStamp() % 1000L));
        }
        this.add("severity", this.includeLevel, logbackToSeverityMap.getOrDefault(event.getLevel(), Severity.DEFAULT.name()), map);
        this.add("thread", this.includeThreadName, event.getThreadName(), map);
        this.add("logger", this.includeLoggerName, event.getLoggerName(), map);
        if (this.includeFormattedMessage) {
            String stackTrace;
            IThrowableProxy throwableProxy;
            String message = event.getFormattedMessage();
            if (this.includeExceptionInMessage && (throwableProxy = event.getThrowableProxy()) != null && (stackTrace = this.getThrowableProxyConverter().convert((Object)event)) != null && !stackTrace.equals("")) {
                message = message + "\n" + stackTrace;
            }
            map.put("message", message);
        }
        this.add("raw-message", this.includeMessage, event.getMessage(), map);
        this.add("context", this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.addThrowableInfo("exception", this.includeException, event, map);
        this.addTraceId(event, map);
        this.add("logging.googleapis.com/spanId", this.includeSpanId, (String)event.getMDCPropertyMap().get("X-B3-SpanId"), map);
        if (this.serviceContext != null) {
            map.put("serviceContext", this.serviceContext);
        }
        if (this.customJson != null && !this.customJson.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.customJson.entrySet()) {
                map.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        this.addCustomDataToJsonMap(map, event);
        return map;
    }

    protected String formatTraceId(String traceId) {
        if (traceId != null && traceId.length() == 16) {
            return "0000000000000000" + traceId;
        }
        return traceId;
    }

    private void addTraceId(ILoggingEvent event, Map<String, Object> map) {
        if (!this.includeTraceId) {
            return;
        }
        String traceId = (String)event.getMDCPropertyMap().get("X-B3-TraceId");
        if (traceId == null) {
            traceId = TraceIdLoggingEnhancer.getCurrentTraceId();
        }
        if (!(StringUtils.isEmpty((Object)traceId) || StringUtils.isEmpty((Object)this.projectId) || this.projectId.endsWith("_IS_UNDEFINED"))) {
            traceId = StackdriverTraceConstants.composeFullTraceName(this.projectId, this.formatTraceId(traceId));
        }
        this.add("logging.googleapis.com/trace", this.includeTraceId, traceId, map);
    }
}

