/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.util.ClassUtils;

public abstract class KubernetesConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public static boolean hasConfigServerInstanceProvider() {
        return !ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null);
    }

    public static KubernetesDiscoveryProperties createKubernetesDiscoveryProperties(Binder binder, BindHandler bindHandler) {
        return (KubernetesDiscoveryProperties)binder.bind("spring.cloud.kubernetes.discovery", Bindable.of(KubernetesDiscoveryProperties.class), bindHandler).orElseGet(KubernetesDiscoveryProperties::new);
    }

    public static KubernetesClientProperties createKubernetesClientProperties(Binder binder, BindHandler bindHandler) {
        return (KubernetesClientProperties)binder.bind("spring.cloud.kubernetes.client", Bindable.of(KubernetesClientProperties.class), bindHandler).orElseGet(KubernetesClientProperties::new);
    }

    public static Boolean getDiscoveryEnabled(Binder binder, BindHandler bindHandler) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Bindable.of(Boolean.class), bindHandler).orElse((Object)false);
    }
}

