/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cloud.kubernetes.commons.EnvReader;
import org.springframework.util.StringUtils;

public final class LeaderUtils {
    private static final String HOSTNAME = "HOSTNAME";

    private LeaderUtils() {
    }

    public static String hostName() throws UnknownHostException {
        String hostName = EnvReader.getEnv(HOSTNAME);
        if (StringUtils.hasText((String)hostName)) {
            return hostName;
        }
        return InetAddress.getLocalHost().getHostName();
    }

    public static void guarded(ReentrantLock lock, Runnable runnable) {
        try {
            lock.lock();
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }
}

