/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.kubernetes.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.config.KubernetesPropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.util.StringUtils;

public class ConfigMapPropertySource
extends KubernetesPropertySource {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySource.class);
    private static final String APPLICATION_YML = "application.yml";
    private static final String APPLICATION_YAML = "application.yaml";
    private static final String APPLICATION_PROPERTIES = "application.properties";
    private static final String PREFIX = "configmap";
    private static final Function<String, Properties> KEY_VALUE_TO_PROPERTIES = s -> {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(s.getBytes()));
            return properties;
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
    };
    private static final Function<Properties, Map<String, String>> PROPERTIES_TO_MAP = p -> p.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));

    public ConfigMapPropertySource(KubernetesClient client, String name, ConfigMapConfigProperties config) {
        this(client, name, null, config);
    }

    public ConfigMapPropertySource(KubernetesClient client, String name, String[] profiles, ConfigMapConfigProperties config) {
        this(client, name, null, profiles, config);
    }

    public ConfigMapPropertySource(KubernetesClient client, String name, String namespace, String[] profiles, ConfigMapConfigProperties config) {
        super(ConfigMapPropertySource.getName(client, name, namespace), ConfigMapPropertySource.asObjectMap(ConfigMapPropertySource.getData(client, name, namespace, profiles, config)));
    }

    private static String getName(KubernetesClient client, String name, String namespace) {
        return PREFIX + "." + name + "." + (namespace == null || namespace.isEmpty() ? client.getNamespace() : namespace);
    }

    private static Map<String, String> getData(KubernetesClient client, String name, String namespace, String[] profiles, ConfigMapConfigProperties config) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (config.isEnableApi()) {
            try {
                ConfigMap map;
                ConfigMap configMap = map = StringUtils.isEmpty((Object)namespace) ? (ConfigMap)((Resource)client.configMaps().withName(name)).get() : (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
                if (map != null) {
                    result.putAll(ConfigMapPropertySource.processAllEntries(map.getData(), profiles));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Can't read configMap with name: [" + name + "] in namespace:[" + namespace + "]. Ignoring"), (Throwable)e);
            }
        }
        HashMap<String, String> configsFromPaths = new HashMap<String, String>();
        ConfigMapPropertySource.putPathConfig(configsFromPaths, config.getPaths());
        result.putAll(ConfigMapPropertySource.processAllEntries(configsFromPaths, profiles));
        return result;
    }

    private static Map<String, String> processAllEntries(Map<String, String> input, String[] profiles) {
        return input.entrySet().stream().map(e -> ConfigMapPropertySource.extractProperties((String)e.getKey(), (String)e.getValue(), profiles)).filter(m -> !m.isEmpty()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    private static Map<String, String> extractProperties(String resourceName, String content, String[] profiles) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (resourceName.equals(APPLICATION_YAML) || resourceName.equals(APPLICATION_YML)) {
            result.putAll(ConfigMapPropertySource.yamlParserGenerator(profiles).andThen(PROPERTIES_TO_MAP).apply(content));
        } else if (resourceName.equals(APPLICATION_PROPERTIES)) {
            result.putAll(KEY_VALUE_TO_PROPERTIES.andThen(PROPERTIES_TO_MAP).apply(content));
        } else {
            result.put(resourceName, content);
        }
        return result;
    }

    private static Map<String, Object> asObjectMap(Map<String, String> source) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Function<String, Properties> yamlParserGenerator(String[] profiles) {
        return s -> {
            YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
            yamlFactory.setResources(new org.springframework.core.io.Resource[]{new ByteArrayResource(s.getBytes())});
            return yamlFactory.getObject();
        };
    }
}

