/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import javax.annotation.PostConstruct;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.scheduling.annotation.Scheduled;

public class PollingConfigurationChangeDetector
extends ConfigurationChangeDetector {
    private ConfigMapPropertySourceLocator configMapPropertySourceLocator;
    private SecretsPropertySourceLocator secretsPropertySourceLocator;

    public PollingConfigurationChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, ConfigMapPropertySourceLocator configMapPropertySourceLocator, SecretsPropertySourceLocator secretsPropertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, kubernetesClient, strategy);
        this.configMapPropertySourceLocator = configMapPropertySourceLocator;
        this.secretsPropertySourceLocator = secretsPropertySourceLocator;
    }

    @PostConstruct
    public void init() {
        this.log.info((Object)"Kubernetes polling configuration change detector activated");
    }

    @Scheduled(initialDelayString="${spring.cloud.kubernetes.reload.period:15000}", fixedDelayString="${spring.cloud.kubernetes.reload.period:15000}")
    public void executeCycle() {
        MapPropertySource currentSecretSource;
        MapPropertySource currentConfigMapSource;
        boolean changedConfigMap = false;
        if (this.properties.isMonitoringConfigMaps() && (currentConfigMapSource = (MapPropertySource)this.findPropertySource(ConfigMapPropertySource.class)) != null) {
            MapPropertySource newConfigMapSource = this.configMapPropertySourceLocator.locate((Environment)this.environment);
            changedConfigMap = this.changed(currentConfigMapSource, newConfigMapSource);
        }
        boolean changedSecrets = false;
        if (this.properties.isMonitoringSecrets() && (currentSecretSource = (MapPropertySource)this.findPropertySource(SecretsPropertySource.class)) != null) {
            MapPropertySource newSecretSource = this.secretsPropertySourceLocator.locate((Environment)this.environment);
            changedSecrets = this.changed(currentSecretSource, newSecretSource);
        }
        if (changedConfigMap || changedSecrets) {
            this.reloadProperties();
        }
    }
}

