/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.stoyanr.evictor.ConcurrentMapWithTimedEviction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.loadbalancer.cache.CaffeineBasedLoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.DefaultLoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CacheManager.class, CacheAutoConfiguration.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
@EnableConfigurationProperties(value={LoadBalancerCacheProperties.class})
@Conditional(value={OnLoadBalancerCachingEnabledCondition.class})
public class LoadBalancerCacheAutoConfiguration {

    static final class OnLoadBalancerCachingEnabledCondition
    extends AllNestedConditions {
        OnLoadBalancerCachingEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.cache.enabled"}, matchIfMissing=true)
        static class LoadBalancerCacheEnabled {
            LoadBalancerCacheEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.enabled"}, havingValue="true", matchIfMissing=true)
        static class LoadBalancerEnabled {
            LoadBalancerEnabled() {
            }
        }
    }

    static final class OnCaffeineCacheMissingCondition
    extends AnyNestedCondition {
        private OnCaffeineCacheMissingCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingClass(value={"org.springframework.cache.caffeine.CaffeineCacheManager"})
        static class CaffeineCacheManagerClassMissing {
            CaffeineCacheManagerClassMissing() {
            }
        }

        @ConditionalOnMissingClass(value={"com.github.benmanes.caffeine.cache.Caffeine"})
        static class CaffeineClassMissing {
            CaffeineClassMissing() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnCaffeineCacheMissingCondition.class})
    @ConditionalOnClass(value={ConcurrentMapWithTimedEviction.class})
    protected static class DefaultLoadBalancerCacheManagerConfiguration {
        protected DefaultLoadBalancerCacheManagerConfiguration() {
        }

        @Bean(autowireCandidate=false)
        @ConditionalOnMissingBean
        LoadBalancerCacheManager defaultLoadBalancerCacheManager(LoadBalancerCacheProperties cacheProperties) {
            return new DefaultLoadBalancerCacheManager(cacheProperties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Caffeine.class, CaffeineCacheManager.class})
    protected static class CaffeineLoadBalancerCacheManagerConfiguration {
        protected CaffeineLoadBalancerCacheManagerConfiguration() {
        }

        @Bean(autowireCandidate=false)
        @ConditionalOnMissingBean
        LoadBalancerCacheManager caffeineLoadBalancerCacheManager(LoadBalancerCacheProperties cacheProperties) {
            return new CaffeineBasedLoadBalancerCacheManager(cacheProperties);
        }
    }

    static class LoadBalancerCaffeineWarnLogger
    implements InitializingBean {
        private static final Log LOG = LogFactory.getLog(LoadBalancerCaffeineWarnLogger.class);

        LoadBalancerCaffeineWarnLogger() {
        }

        public void afterPropertiesSet() {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Spring Cloud LoadBalancer is currently working with the default cache. While this cache implementation is useful for development and tests, it's recommended to use Caffeine cache in production.You can switch to using Caffeine cache, by adding it and org.springframework.cache.caffeine.CaffeineCacheManager to the classpath.");
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnCaffeineCacheMissingCondition.class})
    protected static class LoadBalancerCacheManagerWarnConfiguration {
        protected LoadBalancerCacheManagerWarnConfiguration() {
        }

        @Bean
        LoadBalancerCaffeineWarnLogger caffeineWarnLogger() {
            return new LoadBalancerCaffeineWarnLogger();
        }
    }
}

