/*
 * Copyright 2013-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.netflix.archaius;

import com.netflix.config.ConfigurationManager;
import org.apache.commons.configuration.AbstractConfiguration;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * @author Dave Syer
 */
public final class ArchaiusDelegatingProxyUtils {

	private ArchaiusDelegatingProxyUtils() {
	}

	/**
	 * {@code ApplicationContext} class name.
	 */
	public static String APPLICATION_CONTEXT = ApplicationContext.class.getName();

	public static <T> T getNamedInstance(Class<T> type, String name) {
		ApplicationContext context = (ApplicationContext) ConfigurationManager
				.getConfigInstance().getProperty(APPLICATION_CONTEXT);
		return context != null && context.containsBean(name) ? context.getBean(name, type)
				: null;
	}

	public static <T> T getInstanceWithPrefix(Class<T> type, String prefix) {
		String name = prefix + type.getSimpleName();
		return getNamedInstance(type, name);
	}

	public static void addApplicationContext(ConfigurableApplicationContext context) {
		AbstractConfiguration config = ConfigurationManager.getConfigInstance();
		config.clearProperty(APPLICATION_CONTEXT);
		config.setProperty(APPLICATION_CONTEXT, context);
	}

}
