/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.cloud.netflix.eureka.http.RestTemplateEurekaHttpClient;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateTransportClientFactory
implements TransportClientFactory {
    public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
        return new RestTemplateEurekaHttpClient(this.restTemplate(serviceUrl.getServiceUrl()), serviceUrl.getServiceUrl());
    }

    private RestTemplate restTemplate(String serviceUrl) {
        RestTemplate restTemplate = new RestTemplate();
        try {
            String[] credentials;
            URI serviceURI = new URI(serviceUrl);
            if (serviceURI.getUserInfo() != null && (credentials = serviceURI.getUserInfo().split(":")).length == 2) {
                restTemplate.getInterceptors().add(new BasicAuthorizationInterceptor(credentials[0], credentials[1]));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        restTemplate.getMessageConverters().add(0, this.mappingJacksonHttpMessageConverter());
        return restTemplate;
    }

    public MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE));
        converter.getObjectMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        converter.getObjectMapper().configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        return converter;
    }

    public void shutdown() {
    }
}

