/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="eureka.instance")
public class EurekaInstanceConfigBean
implements CloudEurekaInstanceConfig,
EnvironmentAware {
    private static final String UNKNOWN = "unknown";
    private InetUtils.HostInfo hostInfo;
    private InetUtils inetUtils;
    private String appname = "unknown";
    private String appGroupName;
    private boolean instanceEnabledOnit;
    private int nonSecurePort = 80;
    private int securePort = 443;
    private boolean nonSecurePortEnabled = true;
    private boolean securePortEnabled;
    private int leaseRenewalIntervalInSeconds = 30;
    private int leaseExpirationDurationInSeconds = 90;
    private String virtualHostName = "unknown";
    private String instanceId;
    private String secureVirtualHostName = "unknown";
    private String aSGName;
    private Map<String, String> metadataMap = new HashMap<String, String>();
    private DataCenterInfo dataCenterInfo = new MyDataCenterInfo(DataCenterInfo.Name.MyOwn);
    private String ipAddress;
    private String statusPageUrlPath = "/info";
    private String statusPageUrl;
    private String homePageUrlPath = "/";
    private String homePageUrl;
    private String healthCheckUrlPath = "/health";
    private String healthCheckUrl;
    private String secureHealthCheckUrl;
    private String namespace = "eureka";
    private String hostname;
    private boolean preferIpAddress = false;
    private InstanceInfo.InstanceStatus initialStatus = InstanceInfo.InstanceStatus.UP;
    private String[] defaultAddressResolutionOrder = new String[0];
    private Environment environment;

    public String getHostname() {
        return this.getHostName(false);
    }

    private EurekaInstanceConfigBean() {
    }

    public EurekaInstanceConfigBean(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
        this.hostInfo = this.inetUtils.findFirstNonLoopbackHostInfo();
        this.ipAddress = this.hostInfo.getIpAddress();
        this.hostname = this.hostInfo.getHostname();
    }

    public String getInstanceId() {
        if (this.instanceId == null && this.metadataMap != null) {
            return this.metadataMap.get("instanceId");
        }
        return this.instanceId;
    }

    public boolean getSecurePortEnabled() {
        return this.securePortEnabled;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.hostInfo.override = true;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        this.hostInfo.override = true;
    }

    public String getHostName(boolean refresh) {
        if (refresh && !this.hostInfo.override) {
            this.ipAddress = this.hostInfo.getIpAddress();
            this.hostname = this.hostInfo.getHostname();
        }
        return this.preferIpAddress ? this.ipAddress : this.hostname;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        String springAppName = this.environment.getProperty("spring.application.name", "");
        if (StringUtils.hasText((String)springAppName)) {
            this.setAppname(springAppName);
            this.setVirtualHostName(springAppName);
            this.setSecureVirtualHostName(springAppName);
        }
    }

    private InetUtils.HostInfo getHostInfo() {
        return this.hostInfo;
    }

    private void setHostInfo(InetUtils.HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    private InetUtils getInetUtils() {
        return this.inetUtils;
    }

    private void setInetUtils(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
    }

    public String getAppname() {
        return this.appname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public String getAppGroupName() {
        return this.appGroupName;
    }

    public void setAppGroupName(String appGroupName) {
        this.appGroupName = appGroupName;
    }

    public boolean isInstanceEnabledOnit() {
        return this.instanceEnabledOnit;
    }

    public void setInstanceEnabledOnit(boolean instanceEnabledOnit) {
        this.instanceEnabledOnit = instanceEnabledOnit;
    }

    public int getNonSecurePort() {
        return this.nonSecurePort;
    }

    @Override
    public void setNonSecurePort(int nonSecurePort) {
        this.nonSecurePort = nonSecurePort;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    @Override
    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    public boolean isNonSecurePortEnabled() {
        return this.nonSecurePortEnabled;
    }

    public void setNonSecurePortEnabled(boolean nonSecurePortEnabled) {
        this.nonSecurePortEnabled = nonSecurePortEnabled;
    }

    public boolean isSecurePortEnabled() {
        return this.securePortEnabled;
    }

    public void setSecurePortEnabled(boolean securePortEnabled) {
        this.securePortEnabled = securePortEnabled;
    }

    public int getLeaseRenewalIntervalInSeconds() {
        return this.leaseRenewalIntervalInSeconds;
    }

    public void setLeaseRenewalIntervalInSeconds(int leaseRenewalIntervalInSeconds) {
        this.leaseRenewalIntervalInSeconds = leaseRenewalIntervalInSeconds;
    }

    public int getLeaseExpirationDurationInSeconds() {
        return this.leaseExpirationDurationInSeconds;
    }

    public void setLeaseExpirationDurationInSeconds(int leaseExpirationDurationInSeconds) {
        this.leaseExpirationDurationInSeconds = leaseExpirationDurationInSeconds;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public void setVirtualHostName(String virtualHostName) {
        this.virtualHostName = virtualHostName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getSecureVirtualHostName() {
        return this.secureVirtualHostName;
    }

    public void setSecureVirtualHostName(String secureVirtualHostName) {
        this.secureVirtualHostName = secureVirtualHostName;
    }

    public String getASGName() {
        return this.aSGName;
    }

    public void setASGName(String aSGName) {
        this.aSGName = aSGName;
    }

    public Map<String, String> getMetadataMap() {
        return this.metadataMap;
    }

    public void setMetadataMap(Map<String, String> metadataMap) {
        this.metadataMap = metadataMap;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public void setDataCenterInfo(DataCenterInfo dataCenterInfo) {
        this.dataCenterInfo = dataCenterInfo;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getStatusPageUrlPath() {
        return this.statusPageUrlPath;
    }

    public void setStatusPageUrlPath(String statusPageUrlPath) {
        this.statusPageUrlPath = statusPageUrlPath;
    }

    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    public void setStatusPageUrl(String statusPageUrl) {
        this.statusPageUrl = statusPageUrl;
    }

    public String getHomePageUrlPath() {
        return this.homePageUrlPath;
    }

    public void setHomePageUrlPath(String homePageUrlPath) {
        this.homePageUrlPath = homePageUrlPath;
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public void setHomePageUrl(String homePageUrl) {
        this.homePageUrl = homePageUrl;
    }

    public String getHealthCheckUrlPath() {
        return this.healthCheckUrlPath;
    }

    public void setHealthCheckUrlPath(String healthCheckUrlPath) {
        this.healthCheckUrlPath = healthCheckUrlPath;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public String getSecureHealthCheckUrl() {
        return this.secureHealthCheckUrl;
    }

    public void setSecureHealthCheckUrl(String secureHealthCheckUrl) {
        this.secureHealthCheckUrl = secureHealthCheckUrl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isPreferIpAddress() {
        return this.preferIpAddress;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    @Override
    public InstanceInfo.InstanceStatus getInitialStatus() {
        return this.initialStatus;
    }

    public void setInitialStatus(InstanceInfo.InstanceStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    public String[] getDefaultAddressResolutionOrder() {
        return this.defaultAddressResolutionOrder;
    }

    public void setDefaultAddressResolutionOrder(String[] defaultAddressResolutionOrder) {
        this.defaultAddressResolutionOrder = defaultAddressResolutionOrder;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EurekaInstanceConfigBean that = (EurekaInstanceConfigBean)o;
        return Objects.equals(this.hostInfo, that.hostInfo) && Objects.equals(this.inetUtils, that.inetUtils) && Objects.equals(this.appname, that.appname) && Objects.equals(this.appGroupName, that.appGroupName) && this.instanceEnabledOnit == that.instanceEnabledOnit && this.nonSecurePort == that.nonSecurePort && this.securePort == that.securePort && this.nonSecurePortEnabled == that.nonSecurePortEnabled && this.securePortEnabled == that.securePortEnabled && this.leaseRenewalIntervalInSeconds == that.leaseRenewalIntervalInSeconds && this.leaseExpirationDurationInSeconds == that.leaseExpirationDurationInSeconds && Objects.equals(this.virtualHostName, that.virtualHostName) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.secureVirtualHostName, that.secureVirtualHostName) && Objects.equals(this.aSGName, that.aSGName) && Objects.equals(this.metadataMap, that.metadataMap) && Objects.equals(this.dataCenterInfo, that.dataCenterInfo) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.statusPageUrlPath, that.statusPageUrlPath) && Objects.equals(this.statusPageUrl, that.statusPageUrl) && Objects.equals(this.homePageUrlPath, that.homePageUrlPath) && Objects.equals(this.homePageUrl, that.homePageUrl) && Objects.equals(this.healthCheckUrlPath, that.healthCheckUrlPath) && Objects.equals(this.healthCheckUrl, that.healthCheckUrl) && Objects.equals(this.secureHealthCheckUrl, that.secureHealthCheckUrl) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.hostname, that.hostname) && this.preferIpAddress == that.preferIpAddress && Objects.equals(this.initialStatus, that.initialStatus) && Arrays.equals(this.defaultAddressResolutionOrder, that.defaultAddressResolutionOrder) && Objects.equals(this.environment, that.environment);
    }

    public int hashCode() {
        return Objects.hash(this.hostInfo, this.inetUtils, this.appname, this.appGroupName, this.instanceEnabledOnit, this.nonSecurePort, this.securePort, this.nonSecurePortEnabled, this.securePortEnabled, this.leaseRenewalIntervalInSeconds, this.leaseExpirationDurationInSeconds, this.virtualHostName, this.instanceId, this.secureVirtualHostName, this.aSGName, this.metadataMap, this.dataCenterInfo, this.ipAddress, this.statusPageUrlPath, this.statusPageUrl, this.homePageUrlPath, this.homePageUrl, this.healthCheckUrlPath, this.healthCheckUrl, this.secureHealthCheckUrl, this.namespace, this.hostname, this.preferIpAddress, this.initialStatus, this.defaultAddressResolutionOrder, this.environment);
    }

    public String toString() {
        return "EurekaInstanceConfigBean{" + "hostInfo=" + this.hostInfo + ", " + "inetUtils=" + this.inetUtils + ", " + "appname='" + this.appname + "', " + "appGroupName='" + this.appGroupName + "', " + "instanceEnabledOnit=" + this.instanceEnabledOnit + ", " + "nonSecurePort=" + this.nonSecurePort + ", " + "securePort=" + this.securePort + ", " + "nonSecurePortEnabled=" + this.nonSecurePortEnabled + ", " + "securePortEnabled=" + this.securePortEnabled + ", " + "leaseRenewalIntervalInSeconds=" + this.leaseRenewalIntervalInSeconds + ", " + "leaseExpirationDurationInSeconds=" + this.leaseExpirationDurationInSeconds + ", " + "virtualHostName='" + this.virtualHostName + "', " + "instanceId='" + this.instanceId + "', " + "secureVirtualHostName='" + this.secureVirtualHostName + "', " + "aSGName='" + this.aSGName + "', " + "metadataMap=" + this.metadataMap + ", " + "dataCenterInfo=" + this.dataCenterInfo + ", " + "ipAddress='" + this.ipAddress + "', " + "statusPageUrlPath='" + this.statusPageUrlPath + "', " + "statusPageUrl='" + this.statusPageUrl + "', " + "homePageUrlPath='" + this.homePageUrlPath + "', " + "homePageUrl='" + this.homePageUrl + "', " + "healthCheckUrlPath='" + this.healthCheckUrlPath + "', " + "healthCheckUrl='" + this.healthCheckUrl + "', " + "secureHealthCheckUrl='" + this.secureHealthCheckUrl + "', " + "namespace='" + this.namespace + "', " + "hostname='" + this.hostname + "', " + "preferIpAddress=" + this.preferIpAddress + ", " + "initialStatus=" + this.initialStatus + ", " + "defaultAddressResolutionOrder=" + Arrays.toString(this.defaultAddressResolutionOrder) + ", " + "environment=" + this.environment + ", " + "}";
    }
}

