/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EurekaDiscoveryClient
implements DiscoveryClient {
    public static final String DESCRIPTION = "Spring Cloud Eureka Discovery Client";
    private final EurekaInstanceConfig config;
    private final EurekaClient eurekaClient;

    public EurekaDiscoveryClient(EurekaInstanceConfig config, EurekaClient eurekaClient) {
        this.config = config;
        this.eurekaClient = eurekaClient;
    }

    public String description() {
        return DESCRIPTION;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List infos = this.eurekaClient.getInstancesByVipAddress(serviceId, false);
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (InstanceInfo info : infos) {
            instances.add(new EurekaServiceInstance(info));
        }
        return instances;
    }

    public List<String> getServices() {
        Applications applications = this.eurekaClient.getApplications();
        if (applications == null) {
            return Collections.emptyList();
        }
        List registered = applications.getRegisteredApplications();
        ArrayList<String> names = new ArrayList<String>();
        for (Application app : registered) {
            if (app.getInstances().isEmpty()) continue;
            names.add(app.getName().toLowerCase());
        }
        return names;
    }

    public int getOrder() {
        EurekaClientConfig clientConfig = this.eurekaClient.getEurekaClientConfig();
        return clientConfig instanceof Ordered ? ((Ordered)clientConfig).getOrder() : 0;
    }

    public static class EurekaServiceInstance
    implements ServiceInstance {
        private InstanceInfo instance;

        public EurekaServiceInstance(InstanceInfo instance) {
            Assert.notNull((Object)instance, (String)"Service instance required");
            this.instance = instance;
        }

        public InstanceInfo getInstanceInfo() {
            return this.instance;
        }

        public String getServiceId() {
            return this.instance.getAppName();
        }

        public String getHost() {
            return this.instance.getHostName();
        }

        public int getPort() {
            if (this.isSecure()) {
                return this.instance.getSecurePort();
            }
            return this.instance.getPort();
        }

        public boolean isSecure() {
            return this.instance.isPortEnabled(InstanceInfo.PortType.SECURE);
        }

        public URI getUri() {
            return DefaultServiceInstance.getUri((ServiceInstance)this);
        }

        public Map<String, String> getMetadata() {
            return this.instance.getMetadata();
        }
    }
}

