/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.blitz4j.DefaultBlitz4jConfig;
import com.netflix.blitz4j.LoggingConfiguration;
import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.XmlXStream;
import com.netflix.eureka.EurekaBootStrap;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.InstanceRegistry;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.thoughtworks.xstream.MarshallingStrategy;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.boot.logging.log4j.Log4JLoggingSystem;
import org.springframework.cloud.netflix.eureka.DataCenterAwareMarshallingStrategy;
import org.springframework.cloud.netflix.eureka.DiscoveryManagerInitializer;
import org.springframework.cloud.netflix.eureka.EurekaServerConfigBean;
import org.springframework.cloud.netflix.eureka.server.advice.LeaseManagerLite;
import org.springframework.cloud.netflix.eureka.server.advice.PiggybackMethodInterceptor;
import org.springframework.cloud.netflix.eureka.server.event.EurekaRegistryAvailableEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaServerStartedEvent;
import org.springframework.cloud.netflix.eureka.server.event.LeaseManagerMessageBroker;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.ServletContextAware;

@Configuration
@EnableConfigurationProperties(value={EurekaServerConfigBean.class})
public class EurekaServerInitializerConfiguration
implements ServletContextAware,
SmartLifecycle,
Ordered {
    private static Log logger = LogFactory.getLog(EurekaServerInitializerConfiguration.class);
    @Autowired
    private EurekaServerConfig eurekaServerConfig;
    private ServletContext servletContext;
    @Autowired
    private ApplicationContext applicationContext;
    private boolean running;
    private int order = 1;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @PostConstruct
    public void initLogging() {
        if (!(LoggingSystem.get((ClassLoader)ClassUtils.getDefaultClassLoader()) instanceof Log4JLoggingSystem)) {
            LoggingConfiguration off = new LoggingConfiguration(){

                public void configure() {
                }
            };
            Field instance = ReflectionUtils.findField(LoggingConfiguration.class, (String)"instance");
            ReflectionUtils.makeAccessible((Field)instance);
            ReflectionUtils.setField((Field)instance, null, (Object)off);
            Field blitz4j = ReflectionUtils.findField(LoggingConfiguration.class, (String)"blitz4jConfig");
            ReflectionUtils.makeAccessible((Field)blitz4j);
            try {
                Properties props = PropertiesLoaderUtils.loadAllProperties((String)new ClassPathResource("log4j.properties", Log4JLoggingSystem.class).toString());
                DefaultBlitz4jConfig blit4jConfig = new DefaultBlitz4jConfig(props);
                ReflectionUtils.setField((Field)blitz4j, (Object)off, (Object)blit4jConfig);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={DiscoveryManagerInitializer.class})
    public DiscoveryManagerInitializer discoveryManagerIntitializer() {
        return new DiscoveryManagerInitializer();
    }

    public void start() {
        this.discoveryManagerIntitializer().init();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new EurekaBootStrap(){

                        protected void initEurekaEnvironment() {
                            try {
                                if (System.getProperty("log4j.configuration") == null) {
                                    System.setProperty("log4j.configuration", new ClassPathResource("log4j.properties", Log4JLoggingSystem.class).getURL().toString());
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            LoggingConfiguration.getInstance().configure();
                            EurekaServerConfigurationManager.getInstance().setConfiguration(EurekaServerInitializerConfiguration.this.eurekaServerConfig);
                            XmlXStream.getInstance().setMarshallingStrategy((MarshallingStrategy)new DataCenterAwareMarshallingStrategy(EurekaServerInitializerConfiguration.this.applicationContext));
                            JsonXStream.getInstance().setMarshallingStrategy((MarshallingStrategy)new DataCenterAwareMarshallingStrategy(EurekaServerInitializerConfiguration.this.applicationContext));
                            EurekaServerInitializerConfiguration.this.applicationContext.publishEvent((ApplicationEvent)new EurekaRegistryAvailableEvent(EurekaServerInitializerConfiguration.this.eurekaServerConfig));
                        }
                    }.contextInitialized(new ServletContextEvent(EurekaServerInitializerConfiguration.this.servletContext));
                    logger.info((Object)"Started Eureka Server");
                    EurekaServerInitializerConfiguration.this.running = true;
                    EurekaServerInitializerConfiguration.this.applicationContext.publishEvent((ApplicationEvent)new EurekaServerStartedEvent(EurekaServerInitializerConfiguration.this.eurekaServerConfig));
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not initialize Eureka servlet context", (Throwable)ex);
                }
            }
        }).start();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public int getOrder() {
        return this.order;
    }

    @Configuration
    @ConditionalOnClass(value={PeerAwareInstanceRegistry.class})
    protected static class RegistryInstanceProxyInitializer
    implements ApplicationListener<EurekaRegistryAvailableEvent> {
        @Autowired
        private ApplicationContext applicationContext;
        private PeerAwareInstanceRegistry instance;

        protected RegistryInstanceProxyInitializer() {
        }

        @Bean
        public LeaseManagerMessageBroker leaseManagerMessageBroker() {
            return new LeaseManagerMessageBroker();
        }

        public void onApplicationEvent(EurekaRegistryAvailableEvent event) {
            if (this.instance == null) {
                this.instance = PeerAwareInstanceRegistry.getInstance();
                this.safeInit();
                this.replaceInstance(this.getProxyForInstance());
                this.expectRegistrations(1);
            }
        }

        private void safeInit() {
            Method method = ReflectionUtils.findMethod(InstanceRegistry.class, (String)"postInit");
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, (Object)this.instance);
        }

        private void replaceInstance(Object proxy) {
            Field field = ReflectionUtils.findField(PeerAwareInstanceRegistry.class, (String)"instance");
            try {
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                ReflectionUtils.setField((Field)field, null, (Object)proxy);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot modify instance registry", ex);
            }
        }

        private Object getProxyForInstance() {
            ProxyFactory factory = new ProxyFactory((Object)this.instance);
            factory.addAdvice((Advice)new PiggybackMethodInterceptor(this.leaseManagerMessageBroker(), LeaseManagerLite.class));
            factory.addAdvice((Advice)new TrafficOpener());
            factory.setProxyTargetClass(true);
            return factory.getProxy();
        }

        private void expectRegistrations(int count) {
            Field field = ReflectionUtils.findField(PeerAwareInstanceRegistry.class, (String)"expectedNumberOfRenewsPerMin");
            try {
                field.setAccessible(true);
                int value = (Integer)ReflectionUtils.getField((Field)field, (Object)this.instance);
                if (value == 0 && count > 0) {
                    ReflectionUtils.setField((Field)field, (Object)this.instance, (Object)count);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot modify instance registry expected renews", ex);
            }
        }

        private class TrafficOpener
        implements MethodInterceptor {
            private TrafficOpener() {
            }

            public Object invoke(MethodInvocation invocation) throws Throwable {
                if ("openForTraffic".equals(invocation.getMethod().getName())) {
                    int count = (Integer)invocation.getArguments()[0];
                    ReflectionUtils.invokeMethod((Method)invocation.getMethod(), (Object)invocation.getThis(), (Object[])new Object[]{count == 0 ? 1 : count});
                    return null;
                }
                return invocation.proceed();
            }
        }
    }
}

