/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.hystrix.HystrixCircuitBreaker;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.hystrix.amqp.HystrixConnectionFactory;
import org.springframework.cloud.netflix.hystrix.amqp.HystrixStreamAmqpProperties;
import org.springframework.cloud.netflix.hystrix.amqp.HystrixStreamChannel;
import org.springframework.cloud.netflix.hystrix.amqp.HystrixStreamTask;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnClass(value={HystrixCircuitBreaker.class, RabbitTemplate.class})
@ConditionalOnProperty(value={"hystrix.stream.amqp.enabled"}, matchIfMissing=true)
@IntegrationComponentScan(basePackageClasses={HystrixStreamChannel.class})
@EnableConfigurationProperties
@EnableScheduling
public class HystrixStreamAutoConfiguration {
    @Autowired(required=false)
    @HystrixConnectionFactory
    private ConnectionFactory hystrixConnectionFactory;
    @Autowired(required=false)
    private ConnectionFactory primaryConnectionFactory;
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    private RabbitTemplate amqpTemplate;

    public RabbitTemplate amqpTemplate() {
        if (this.amqpTemplate == null) {
            RabbitTemplate amqpTemplate = new RabbitTemplate(this.connectionFactory());
            Jackson2JsonMessageConverter converter = this.messageConverter();
            amqpTemplate.setMessageConverter((MessageConverter)converter);
            this.amqpTemplate = amqpTemplate;
        }
        return this.amqpTemplate;
    }

    @Bean
    public HystrixStreamAmqpProperties hystrixStreamAmqpProperties() {
        return new HystrixStreamAmqpProperties();
    }

    @Bean
    public HystrixStreamTask hystrixStreamTask() {
        return new HystrixStreamTask();
    }

    @Bean
    public DirectChannel hystrixStream() {
        return new DirectChannel();
    }

    @Bean
    public DirectExchange hystrixStreamExchange() {
        DirectExchange exchange = new DirectExchange("spring.cloud.hystrix.stream");
        return exchange;
    }

    @Bean
    public IntegrationFlow hystrixStreamOutboundFlow() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"hystrixStream").handle((MessageHandlerSpec)Amqp.outboundAdapter((AmqpTemplate)this.amqpTemplate()).exchangeName("spring.cloud.hystrix.stream"))).get();
    }

    private ConnectionFactory connectionFactory() {
        if (this.hystrixConnectionFactory != null) {
            RabbitAdmin amqpAdmin = new RabbitAdmin(this.hystrixConnectionFactory);
            this.hystrixStreamExchange().setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            amqpAdmin.setApplicationContext(this.context);
            amqpAdmin.afterPropertiesSet();
            return this.hystrixConnectionFactory;
        }
        return this.primaryConnectionFactory;
    }

    private Jackson2JsonMessageConverter messageConverter() {
        Jackson2JsonMessageConverter converter = new Jackson2JsonMessageConverter();
        if (this.objectMapper != null) {
            converter.setJsonObjectMapper(this.objectMapper);
        }
        return converter;
    }
}

