/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix.security;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.hystrix.security.SecurityContextConcurrencyStrategy;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.security.core.context.SecurityContext;

@Configuration(proxyBeanMethods=false)
@Conditional(value={HystrixSecurityCondition.class})
@ConditionalOnClass(value={Hystrix.class, SecurityContext.class})
public class HystrixSecurityAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(HystrixSecurityAutoConfiguration.class);
    @Autowired(required=false)
    private HystrixConcurrencyStrategy existingConcurrencyStrategy;

    @PostConstruct
    public void init() {
        HystrixEventNotifier eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        HystrixMetricsPublisher metricsPublisher = HystrixPlugins.getInstance().getMetricsPublisher();
        HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
        HystrixCommandExecutionHook commandExecutionHook = HystrixPlugins.getInstance().getCommandExecutionHook();
        HystrixConcurrencyStrategy concurrencyStrategy = this.detectRegisteredConcurrencyStrategy();
        HystrixPlugins.reset();
        HystrixPlugins.getInstance().registerConcurrencyStrategy((HystrixConcurrencyStrategy)new SecurityContextConcurrencyStrategy(concurrencyStrategy));
        HystrixPlugins.getInstance().registerEventNotifier(eventNotifier);
        HystrixPlugins.getInstance().registerMetricsPublisher(metricsPublisher);
        HystrixPlugins.getInstance().registerPropertiesStrategy(propertiesStrategy);
        HystrixPlugins.getInstance().registerCommandExecutionHook(commandExecutionHook);
    }

    private HystrixConcurrencyStrategy detectRegisteredConcurrencyStrategy() {
        HystrixConcurrencyStrategy registeredStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        if (this.existingConcurrencyStrategy == null) {
            return registeredStrategy;
        }
        if (registeredStrategy instanceof HystrixConcurrencyStrategyDefault) {
            return this.existingConcurrencyStrategy;
        }
        if (!this.existingConcurrencyStrategy.equals(registeredStrategy)) {
            LOGGER.warn((Object)"Multiple HystrixConcurrencyStrategy detected. Bean of HystrixConcurrencyStrategy was used.");
        }
        return this.existingConcurrencyStrategy;
    }

    static class HystrixSecurityCondition
    extends AllNestedConditions {
        HystrixSecurityCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"hystrix.shareSecurityContext"})
        static class ShareSecurityContext {
            ShareSecurityContext() {
            }
        }
    }
}

