/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.AtomicDouble;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;

public class SpectatorMetricServices
implements CounterService,
GaugeService {
    private final Registry registry;
    private final ConcurrentMap<Id, AtomicLong> counters = new ConcurrentHashMap<Id, AtomicLong>();
    private final ConcurrentMap<Id, AtomicDouble> gauges = new ConcurrentHashMap<Id, AtomicDouble>();

    public SpectatorMetricServices(Registry registry) {
        this.registry = registry;
    }

    protected static String stripMetricName(String metricName) {
        return metricName.replaceFirst("^(timer|histogram|meter)\\.", "");
    }

    public void increment(String name) {
        this.incrementInternal(name, 1L);
    }

    public void decrement(String name) {
        this.incrementInternal(name, -1L);
    }

    private void incrementInternal(String name, long value) {
        if (!name.startsWith("status.")) {
            if (name.startsWith("meter.")) {
                this.registry.counter(SpectatorMetricServices.stripMetricName(name)).increment(value);
            } else {
                Id id = this.registry.createId(name);
                AtomicLong gauge = this.getCounterStorage(id);
                gauge.addAndGet(value);
            }
        }
    }

    public void reset(String name) {
        Id id = this.registry.createId(SpectatorMetricServices.stripMetricName(name));
        this.counters.remove(id);
        this.gauges.remove(id);
    }

    public void submit(String name, double dValue) {
        if (name.startsWith("histogram.")) {
            this.registry.distributionSummary(SpectatorMetricServices.stripMetricName(name)).record((long)dValue);
        } else if (name.startsWith("timer.")) {
            long value = (long)(dValue * 1000000.0);
            this.registry.timer(SpectatorMetricServices.stripMetricName(name)).record(value, TimeUnit.NANOSECONDS);
        } else {
            Id id = this.registry.createId(name);
            AtomicDouble gauge = this.getGaugeStorage(id);
            gauge.set(dValue);
        }
    }

    private AtomicDouble getGaugeStorage(Id id) {
        AtomicDouble newGauge = new AtomicDouble(0.0);
        AtomicDouble existingGauge = this.gauges.putIfAbsent(id, newGauge);
        return existingGauge == null ? (AtomicDouble)this.registry.gauge(id, (Number)newGauge) : existingGauge;
    }

    private AtomicLong getCounterStorage(Id id) {
        AtomicLong newCounter = new AtomicLong(0L);
        AtomicLong existingCounter = this.counters.putIfAbsent(id, newCounter);
        return existingCounter == null ? (AtomicLong)this.registry.gauge(id, (Number)newCounter) : existingCounter;
    }
}

