/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.resource;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cloud.security.oauth2.client.ClientConfiguration;
import org.springframework.cloud.security.oauth2.resource.JwtAccessTokenConverterConfigurer;
import org.springframework.cloud.security.oauth2.resource.ResourceServerProperties;
import org.springframework.cloud.security.oauth2.resource.SpringSocialTokenServices;
import org.springframework.cloud.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Configuration
@Import(value={ClientConfiguration.class})
public class ResourceServerTokenServicesConfiguration {

    private static class NotJwtToken
    extends SpringBootCondition {
        private JwtToken opposite = new JwtToken();

        private NotJwtToken() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionOutcome outcome = this.opposite.getMatchOutcome(context, metadata);
            if (outcome.isMatch()) {
                return ConditionOutcome.noMatch((String)outcome.getMessage());
            }
            return ConditionOutcome.match((String)outcome.getMessage());
        }
    }

    private static class NotTokenInfo
    extends SpringBootCondition {
        private TokenInfo opposite = new TokenInfo();

        private NotTokenInfo() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionOutcome outcome = this.opposite.getMatchOutcome(context, metadata);
            if (outcome.isMatch()) {
                return ConditionOutcome.noMatch((String)outcome.getMessage());
            }
            return ConditionOutcome.match((String)outcome.getMessage());
        }
    }

    private static class JwtToken
    extends SpringBootCondition {
        private JwtToken() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (StringUtils.hasText((String)context.getEnvironment().getProperty("spring.oauth2.resource.jwt.keyValue")) || StringUtils.hasText((String)context.getEnvironment().getProperty("spring.oauth2.resource.jwt.keyUri"))) {
                return ConditionOutcome.match((String)"Public key is provided");
            }
            return ConditionOutcome.noMatch((String)"Public key is not provided");
        }
    }

    private static class TokenInfo
    extends SpringBootCondition {
        private TokenInfo() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean hasUserInfo;
            Environment environment = context.getEnvironment();
            boolean preferTokenInfo = environment.resolvePlaceholders("${spring.oauth2.resource.preferTokenInfo:${OAUTH2_RESOURCE_PREFERTOKENINFO:true}}").equals("true");
            boolean hasTokenInfo = !environment.resolvePlaceholders("${spring.oauth2.resource.tokenInfoUri:}").equals("");
            boolean bl = hasUserInfo = !environment.resolvePlaceholders("${spring.oauth2.resource.userInfoUri:}").equals("");
            if (!hasUserInfo) {
                return ConditionOutcome.match((String)"No user info provided");
            }
            if (hasTokenInfo && preferTokenInfo) {
                return ConditionOutcome.match((String)"Token info endpoint is preferred and user info provided");
            }
            return ConditionOutcome.noMatch((String)"Token info endpoint is not provided");
        }
    }

    @Configuration
    @Conditional(value={JwtToken.class})
    protected static class JwtTokenServicesConfiguration {
        private static final Logger log = LoggerFactory.getLogger(JwtTokenServicesConfiguration.class);
        @Autowired
        private ResourceServerProperties resource;
        @Autowired(required=false)
        private List<JwtAccessTokenConverterConfigurer> configurers = Collections.emptyList();

        protected JwtTokenServicesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
        public ResourceServerTokenServices jwtTokenServices() {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(this.jwtTokenStore());
            return services;
        }

        @Bean
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtTokenEnhancer());
        }

        @Bean
        public JwtAccessTokenConverter jwtTokenEnhancer() {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            String keyValue = this.resource.getJwt().getKeyValue();
            if (!StringUtils.hasText((String)keyValue)) {
                try {
                    keyValue = (String)((Map)new RestTemplate().getForObject(this.resource.getJwt().getKeyUri(), Map.class, new Object[0])).get("value");
                }
                catch (ResourceAccessException e) {
                    log.warn("Failed to fetch token key (you may need to refresh when the auth server is back)");
                }
            } else if (StringUtils.hasText((String)keyValue) && !keyValue.startsWith("-----BEGIN")) {
                converter.setSigningKey(keyValue);
            }
            if (keyValue != null) {
                converter.setVerifierKey(keyValue);
            }
            AnnotationAwareOrderComparator.sort(this.configurers);
            for (JwtAccessTokenConverterConfigurer configurer : this.configurers) {
                configurer.configure(converter);
            }
            return converter;
        }
    }

    @Configuration
    @Conditional(value={NotJwtToken.class})
    protected static class RemoteTokenServicesConfiguration {
        protected RemoteTokenServicesConfiguration() {
        }

        @Configuration
        @ConditionalOnMissingClass(name={"org.springframework.social.connect.support.OAuth2ConnectionFactory"})
        @Conditional(value={NotTokenInfo.class})
        protected static class UserInfoTokenServicesConfiguration {
            @Autowired
            private ResourceServerProperties sso;
            @Autowired
            private AuthorizationCodeResourceDetails client;
            @Autowired(required=false)
            private Map<String, OAuth2RestOperations> resources = Collections.emptyMap();

            protected UserInfoTokenServicesConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public ResourceServerTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.client.getClientId());
                services.setResources(this.resources);
                return services;
            }
        }

        @Configuration
        @ConditionalOnClass(value={OAuth2ConnectionFactory.class})
        @Conditional(value={NotTokenInfo.class})
        protected static class SocialTokenServicesConfiguration {
            @Autowired
            private ResourceServerProperties sso;
            @Autowired
            private AuthorizationCodeResourceDetails client;
            @Autowired(required=false)
            private OAuth2ConnectionFactory<?> connectionFactory;
            @Autowired(required=false)
            private Map<String, OAuth2RestOperations> resources = Collections.emptyMap();

            protected SocialTokenServicesConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={ConnectionFactoryLocator.class})
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public SpringSocialTokenServices socialTokenServices() {
                return new SpringSocialTokenServices(this.connectionFactory, this.client.getClientId());
            }

            @Bean
            @ConditionalOnMissingBean(value={ConnectionFactoryLocator.class, ResourceServerTokenServices.class})
            public ResourceServerTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.client.getClientId());
                services.setResources(this.resources);
                return services;
            }
        }

        @Configuration
        @Conditional(value={TokenInfo.class})
        protected static class TokenInfoServicesConfiguration {
            @Autowired
            private ResourceServerProperties resource;
            @Autowired
            private AuthorizationCodeResourceDetails client;

            protected TokenInfoServicesConfiguration() {
            }

            @Bean
            protected ResourceServerTokenServices remoteTokenServices() {
                RemoteTokenServices services = new RemoteTokenServices();
                services.setCheckTokenEndpointUrl(this.resource.getTokenInfoUri());
                services.setClientId(this.client.getClientId());
                services.setClientSecret(this.client.getClientSecret());
                return services;
            }
        }
    }

    @Configuration
    protected static class ResourceServerPropertiesConfiguration {
        @Autowired
        private AuthorizationCodeResourceDetails client;

        protected ResourceServerPropertiesConfiguration() {
        }

        @Bean
        public ResourceServerProperties resourceServerProperties() {
            return new ResourceServerProperties(this.client.getClientId(), this.client.getClientSecret());
        }
    }
}

