/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.skipper.domain.AbstractEntity;
import org.springframework.cloud.skipper.domain.PackageFile;

@Entity
@Table(name="SkipperPackageMetadata", indexes={@Index(name="idx_pkg_name", columnList="name")})
public class PackageMetadata
extends AbstractEntity {
    @NotNull
    private String apiVersion;
    private String origin;
    @NotNull
    private Long repositoryId;
    @NotNull
    private String repositoryName;
    @NotNull
    private String kind;
    @NotNull
    private String name;
    private String displayName;
    @NotNull
    private String version;
    @Lob
    private String packageSourceUrl;
    @Lob
    private String packageHomeUrl;
    @JsonIgnore
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="packagefile_id", foreignKey=@ForeignKey(name="fk_package_metadata_pfile"))
    private PackageFile packageFile;
    @Lob
    private String tags;
    private String maintainer;
    @Lob
    private String description;
    private String sha256;
    @Lob
    private String iconUrl;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageSourceUrl() {
        return this.packageSourceUrl;
    }

    public void setPackageSourceUrl(String packageSourceUrl) {
        this.packageSourceUrl = packageSourceUrl;
    }

    public String getPackageHomeUrl() {
        return this.packageHomeUrl;
    }

    public void setPackageHomeUrl(String packageHomeUrl) {
        this.packageHomeUrl = packageHomeUrl;
    }

    @JsonIgnore
    public PackageFile getPackageFile() {
        return this.packageFile;
    }

    @JsonIgnore
    public void setPackageFile(PackageFile packageFile) {
        this.packageFile = packageFile;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Long repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageMetadata)) {
            return false;
        }
        PackageMetadata that = (PackageMetadata)o;
        if (this.repositoryId != null ? !this.repositoryId.equals(that.repositoryId) : that.repositoryId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        int result = this.repositoryId != null ? this.repositoryId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PackageMetadata{id='" + this.getId() + '\'' + ", apiVersion='" + this.apiVersion + '\'' + ", origin='" + this.origin + '\'' + ", repositoryName='" + this.repositoryName + '\'' + ", kind='" + this.kind + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", packageSourceUrl='" + this.packageSourceUrl + '\'' + ", packageHomeUrl='" + this.packageHomeUrl + '\'' + ", tags='" + this.tags + '\'' + ", maintainer='" + this.maintainer + '\'' + ", description='" + this.description + '\'' + ", sha256='" + this.sha256 + '\'' + ", iconUrl='" + this.iconUrl + '\'' + '}';
    }
}

