/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.ConditionalOnSleuthWeb;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.LazyTracingFilter;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.TraceWebMvcConfigurer;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.mvc.SpanCustomizingAsyncHandlerInterceptor;
import org.springframework.cloud.sleuth.instrument.web.servlet.TracingFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSleuthWeb
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={HandlerInterceptorAdapter.class})
@Import(value={SpanCustomizingAsyncHandlerInterceptor.class})
class TraceWebServletConfiguration {
    TraceWebServletConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.web.servlet.enabled"}, matchIfMissing=true)
    static class ServletConfiguration {
        ServletConfiguration() {
        }

        @Bean
        TraceWebAspect traceWebAspect(Tracer tracer, CurrentTraceContext currentTraceContext, SpanNamer spanNamer) {
            return new TraceWebAspect(tracer, currentTraceContext, spanNamer);
        }

        @Bean
        FilterRegistrationBean traceWebFilter(BeanFactory beanFactory, SleuthWebProperties webProperties) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new LazyTracingFilter(beanFactory), new ServletRegistrationBean[0]);
            filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            filterRegistrationBean.setOrder(webProperties.getFilterOrder());
            return filterRegistrationBean;
        }

        @Bean
        @ConditionalOnMissingBean
        TracingFilter tracingFilter(CurrentTraceContext currentTraceContext, HttpServerHandler httpServerHandler) {
            return TracingFilter.create((CurrentTraceContext)currentTraceContext, (HttpServerHandler)httpServerHandler);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={WebMvcConfigurer.class})
        @Import(value={TraceWebMvcConfigurer.class})
        protected static class TraceWebMvcAutoConfiguration {
            protected TraceWebMvcAutoConfiguration() {
            }
        }
    }
}

