/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.HookRegisteringBeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.HooksRefresher;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.SleuthReactorProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.reactor.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Mono.class})
@AutoConfigureAfter(name={"org.springframework.cloud.sleuth.autoconfig.instrument.web.TraceWebAutoConfiguration"}, value={BraveAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthReactorProperties.class})
public class TraceReactorAutoConfiguration {
    static final String SLEUTH_REACTOR_EXECUTOR_SERVICE_KEY = "sleuth";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Tracer.class})
    static class TraceReactorConfiguration {
        static final String SLEUTH_TRACE_REACTOR_KEY = TraceReactorConfiguration.class.getName();
        private static final Log log = LogFactory.getLog(TraceReactorConfiguration.class);
        static final boolean IS_QUEUE_WRAPPER_ON_THE_CLASSPATH = TraceReactorConfiguration.isQueueWrapperOnTheClasspath();
        @Autowired
        ConfigurableApplicationContext springContext;

        TraceReactorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        HookRegisteringBeanDefinitionRegistryPostProcessor traceHookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext context) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registering bean definition registry post processor for context [" + context + "]"));
            }
            return new HookRegisteringBeanDefinitionRegistryPostProcessor(context);
        }

        private static boolean isQueueWrapperOnTheClasspath() {
            return ReflectionUtils.findMethod(Hooks.class, (String)"addQueueWrapper", (Class[])new Class[]{String.class, Function.class}) != null;
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={RefreshScope.class})
        static class HooksRefresherConfiguration {
            HooksRefresherConfiguration() {
            }

            @Bean
            HooksRefresher hooksRefresher(SleuthReactorProperties reactorProperties, ConfigurableApplicationContext context) {
                return new HooksRefresher(reactorProperties, context);
            }
        }
    }
}

