/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.quartz;

import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.TriggerListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.quartz.TracingJobListener;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracer.class, Scheduler.class})
@ConditionalOnProperty(value={"spring.sleuth.quartz.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={BraveAutoConfiguration.class, QuartzAutoConfiguration.class})
public class TraceQuartzAutoConfiguration
implements InitializingBean {
    private final Scheduler scheduler;
    private final BeanFactory beanFactory;

    @Deprecated
    public TraceQuartzAutoConfiguration(Scheduler scheduler, Tracer tracer, Propagator propagator) {
        this(scheduler, null);
    }

    @Autowired
    public TraceQuartzAutoConfiguration(Scheduler scheduler, BeanFactory beanFactory) {
        this.scheduler = scheduler;
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        TracingJobListener tracingJobListener = (TracingJobListener)this.beanFactory.getBean(TracingJobListener.class);
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)tracingJobListener);
        this.scheduler.getListenerManager().addJobListener((JobListener)tracingJobListener);
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean
        TracingJobListener tracingJobListener(Tracer tracer, Propagator propagator) {
            return new TracingJobListener(tracer, propagator);
        }
    }
}

