/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.actuate;

import brave.Tracer;
import brave.handler.SpanHandler;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.Producible;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.actuate.BraveFinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.BufferingSpanReporter;
import org.springframework.cloud.sleuth.autoconfig.actuate.FinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.SleuthActuatorProperties;
import org.springframework.cloud.sleuth.autoconfig.actuate.TracesScrapeEndpoint;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.ConditionalOnBraveEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@ConditionalOnAvailableEndpoint(endpoint=TracesScrapeEndpoint.class)
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthActuatorProperties.class})
@ConditionalOnClass(value={Producible.class})
public class TraceSleuthActuatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    BufferingSpanReporter sleuthBufferingSpanReporter(SleuthActuatorProperties sleuthActuatorProperties) {
        return new BufferingSpanReporter(sleuthActuatorProperties.getCapacity());
    }

    @Bean
    @ConditionalOnMissingBean
    TracesScrapeEndpoint sleuthTracesScrapeEndpoint(BufferingSpanReporter bufferingSpanReporter, FinishedSpanWriter finishedSpanWriter) {
        return new TracesScrapeEndpoint(bufferingSpanReporter, finishedSpanWriter);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnBraveEnabled
    static class BraveActuatorConfiguration {
        BraveActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        FinishedSpanWriter sleuthBraveFinishedSpanWriter() {
            return new BraveFinishedSpanWriter();
        }

        @Bean
        SpanHandler sleuthBraveCustomSpanHandler() {
            return new SpanHandler(){};
        }
    }
}

