/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.redis;

import brave.Tracing;
import brave.sampler.Sampler;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import io.lettuce.core.tracing.BraveTracing;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.redis.TraceRedisProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.redis.TraceRedisAutoConfiguration;
import org.springframework.cloud.sleuth.brave.instrument.redis.ClientResourcesBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.redis.TraceLettuceClientResourcesBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.redis.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class, TraceRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceRedisProperties.class})
@ConditionalOnClass(value={BraveTracing.class})
public class BraveRedisAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.redis.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    static class NewBraveLettuceConfiguration {
        NewBraveLettuceConfiguration() {
        }

        @Bean
        BraveTracing lettuceBraveTracing(Tracing tracing, TraceRedisProperties traceRedisProperties) {
            return BraveTracing.builder().tracing(tracing).excludeCommandArgsFromSpanTags().serviceName(traceRedisProperties.getRemoteServiceName()).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.redis.legacy.enabled"})
    static class LegacyBraveOnlyLettuceConfiguration {
        LegacyBraveOnlyLettuceConfiguration() {
        }

        @Bean(destroyMethod="shutdown")
        @ConditionalOnMissingBean(value={ClientResources.class, TraceLettuceClientResourcesBuilderCustomizer.class})
        DefaultClientResources traceLettuceClientResources(ObjectProvider<ClientResourcesBuilderCustomizer> customizer) {
            DefaultClientResources.Builder builder = DefaultClientResources.builder();
            customizer.stream().forEach(c -> c.customize((ClientResources.Builder)builder));
            return builder.build();
        }

        @Bean
        @ConditionalOnMissingBean(value={TraceLettuceClientResourcesBuilderCustomizer.class})
        org.springframework.cloud.sleuth.brave.instrument.redis.TraceLettuceClientResourcesBuilderCustomizer traceBraveOnlyLettuceClientResourcesBuilderCustomizer(Tracing tracing, TraceRedisProperties traceRedisProperties, Sampler sampler) {
            this.eagerlyInitializePotentiallyRefreshScopeSampler(sampler);
            return new org.springframework.cloud.sleuth.brave.instrument.redis.TraceLettuceClientResourcesBuilderCustomizer(tracing, traceRedisProperties.getRemoteServiceName());
        }

        private void eagerlyInitializePotentiallyRefreshScopeSampler(Sampler sampler) {
            sampler.isSampled(0L);
        }
    }
}

