/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.sleuth.web")
public class SleuthWebProperties {
    public static final int TRACING_FILTER_ORDER = -2147483643;
    public static final String DEFAULT_SKIP_PATTERN = "/api-docs.*|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
    private boolean enabled = true;
    private String skipPattern = "/api-docs.*|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
    private String additionalSkipPattern;
    private int filterOrder = -2147483643;
    private boolean ignoreAutoConfiguredSkipPatterns = false;
    private Client client = new Client();
    private Servlet servlet = new Servlet();

    public static String getDefaultSkipPattern() {
        return DEFAULT_SKIP_PATTERN;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getSkipPattern() {
        return this.skipPattern;
    }

    public void setSkipPattern(String skipPattern) {
        this.skipPattern = SleuthWebProperties.emptyToNull(skipPattern);
    }

    public String getAdditionalSkipPattern() {
        return this.additionalSkipPattern;
    }

    public void setAdditionalSkipPattern(String additionalSkipPattern) {
        this.additionalSkipPattern = SleuthWebProperties.emptyToNull(additionalSkipPattern);
    }

    public int getFilterOrder() {
        return this.filterOrder;
    }

    public void setFilterOrder(int filterOrder) {
        this.filterOrder = filterOrder;
    }

    public boolean isIgnoreAutoConfiguredSkipPatterns() {
        return this.ignoreAutoConfiguredSkipPatterns;
    }

    public void setIgnoreAutoConfiguredSkipPatterns(boolean ignoreAutoConfiguredSkipPatterns) {
        this.ignoreAutoConfiguredSkipPatterns = ignoreAutoConfiguredSkipPatterns;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    static String emptyToNull(String skipPattern) {
        if (skipPattern != null && skipPattern.isEmpty()) {
            skipPattern = null;
        }
        return skipPattern;
    }

    public static class Client {
        private String skipPattern;
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getSkipPattern() {
            return this.skipPattern;
        }

        public void setSkipPattern(String skipPattern) {
            this.skipPattern = SleuthWebProperties.emptyToNull(skipPattern);
        }
    }

    public static class Servlet {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Template {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class AsyncClient {
        private boolean enabled;
        @NestedConfigurationProperty
        private Template template;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Template getTemplate() {
            return this.template;
        }

        public void setTemplate(Template template) {
            this.template = template;
        }
    }

    public static class Async {
        @NestedConfigurationProperty
        private AsyncClient client;

        public AsyncClient getClient() {
            return this.client;
        }

        public void setClient(AsyncClient client) {
            this.client = client;
        }
    }
}

