/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.beans.BeansException;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class TraceWebFilter
implements WebFilter,
Ordered,
ApplicationContextAware {
    protected static final String TRACE_REQUEST_ATTR = Span.class.getName();
    static final String MVC_CONTROLLER_CLASS_KEY = "mvc.controller.class";
    static final String MVC_CONTROLLER_METHOD_KEY = "mvc.controller.method";
    private static final Log log = LogFactory.getLog(TraceWebFilter.class);
    private static final String STATUS_CODE_KEY = "http.status_code";
    private static final String TRACE_SPAN_WITHOUT_PARENT = TraceWebFilter.class.getName() + ".SPAN_WITH_NO_PARENT";
    private final Tracer tracer;
    private final HttpServerHandler handler;
    private CurrentTraceContext currentTraceContext;
    private ApplicationContext applicationContext;
    private int order;

    @Deprecated
    public TraceWebFilter(Tracer tracer, HttpServerHandler handler) {
        this.tracer = tracer;
        this.handler = handler;
        this.currentTraceContext = null;
    }

    public TraceWebFilter(Tracer tracer, HttpServerHandler handler, CurrentTraceContext currentTraceContext) {
        this.tracer = tracer;
        this.handler = handler;
        this.currentTraceContext = currentTraceContext;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String uri = exchange.getRequest().getPath().pathWithinApplication().value();
        Mono source = chain.filter(exchange);
        boolean tracePresent = this.isTracePresent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "]"));
        }
        return new MonoWebFilterTrace((Mono<? extends Void>)source, exchange, tracePresent, this);
    }

    private boolean isTracePresent() {
        boolean tracePresent;
        boolean bl = tracePresent = this.tracer.currentSpan() != null;
        if (tracePresent) {
            this.tracer.withSpan(null);
        }
        return tracePresent;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.applicationContext.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    static final class WrappedResponse
    implements HttpServerResponse {
        final ServerHttpResponse delegate;
        final String method;
        final String httpRoute;
        final Throwable throwable;

        WrappedResponse(ServerHttpResponse resp, String method, String httpRoute, Throwable throwable) {
            this.delegate = resp;
            this.method = method;
            this.httpRoute = httpRoute;
            this.throwable = throwable;
        }

        public String method() {
            return this.method;
        }

        public String route() {
            return this.httpRoute;
        }

        public ServerHttpResponse unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            if (this.throwable != null && this.throwable instanceof ResponseStatusException) {
                return ((ResponseStatusException)this.throwable).getRawStatusCode();
            }
            HttpStatus statusCode = this.delegate.getStatusCode();
            return statusCode != null ? statusCode.value() : 0;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public Throwable error() {
            return this.throwable;
        }
    }

    static final class WrappedRequest
    implements HttpServerRequest {
        final ServerHttpRequest delegate;

        WrappedRequest(ServerHttpRequest delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public ServerHttpRequest unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethodValue();
        }

        public String path() {
            return this.delegate.getPath().toString();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            return this.delegate.getHeaders().getFirst(name);
        }
    }

    private static class MonoWebFilterTrace
    extends MonoOperator<Void, Void>
    implements TraceContextPropagator {
        final ServerWebExchange exchange;
        final Tracer tracer;
        final Span span;
        final HttpServerHandler handler;
        final AtomicBoolean initialSpanAlreadyRemoved = new AtomicBoolean();
        final boolean initialTracePresent;
        final CurrentTraceContext currentTraceContext;

        MonoWebFilterTrace(Mono<? extends Void> source, ServerWebExchange exchange, boolean initialTracePresent, TraceWebFilter parent) {
            super(source);
            this.tracer = parent.tracer;
            this.handler = parent.handler;
            this.currentTraceContext = parent.currentTraceContext();
            this.exchange = exchange;
            this.span = (Span)exchange.getAttribute(TRACE_REQUEST_ATTR);
            this.initialTracePresent = initialTracePresent;
        }

        public void subscribe(CoreSubscriber<? super Void> subscriber) {
            Context context = this.contextWithoutInitialSpan(subscriber.currentContext());
            Span span = this.findOrCreateSpan(context);
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
                this.source.subscribe((CoreSubscriber)new WebFilterTraceSubscriber(subscriber, context, span, this));
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return super.scanUnsafe(key);
        }

        private Context contextWithoutInitialSpan(Context context) {
            if (this.initialTracePresent && !this.initialSpanAlreadyRemoved.get()) {
                context = context.delete(Span.class);
                this.initialSpanAlreadyRemoved.set(true);
            }
            return context;
        }

        private Span findOrCreateSpan(Context c) {
            Span span;
            if (c.hasKey(Span.class)) {
                Span parent = (Span)c.get(Span.class);
                try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(parent);){
                    span = this.tracer.nextSpan();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found span in reactor context" + span));
                }
            } else {
                if (this.span != null) {
                    try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(this.span);){
                        span = this.tracer.nextSpan();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found span in attribute " + span));
                    }
                } else {
                    span = this.handler.handleReceive((HttpServerRequest)new WrappedRequest(this.exchange.getRequest()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handled receive of span " + span));
                    }
                }
                this.exchange.getAttributes().put(TRACE_REQUEST_ATTR, span);
            }
            return span;
        }

        static final class WebFilterTraceSubscriber
        implements CoreSubscriber<Void> {
            final CoreSubscriber<? super Void> actual;
            final Context context;
            final Span span;
            final ServerWebExchange exchange;
            final HttpServerHandler handler;

            WebFilterTraceSubscriber(CoreSubscriber<? super Void> actual, Context context, Span span, MonoWebFilterTrace parent) {
                this.actual = actual;
                this.span = span;
                this.context = context.put(TraceContext.class, (Object)span.context());
                this.exchange = parent.exchange;
                this.handler = parent.handler;
            }

            public void onSubscribe(Subscription subscription) {
                this.actual.onSubscribe(subscription);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable t) {
                this.terminateSpan(t);
                this.actual.onError(t);
            }

            public void onComplete() {
                this.terminateSpan(null);
                this.actual.onComplete();
            }

            public Context currentContext() {
                return this.context;
            }

            private void terminateSpan(@Nullable Throwable t) {
                Object attribute = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
                this.addClassMethodTag(attribute, this.span);
                this.addClassNameTag(attribute, this.span);
                Object pattern = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                String httpRoute = pattern != null ? pattern.toString() : "";
                this.addResponseTagsForSpanWithoutParent(this.exchange, this.exchange.getResponse(), this.span);
                WrappedResponse response = new WrappedResponse(this.exchange.getResponse(), this.exchange.getRequest().getMethodValue(), httpRoute, t);
                this.handler.handleSend((HttpServerResponse)response, this.span);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handled send of " + this.span));
                }
            }

            private void addClassMethodTag(Object handler, Span span) {
                if (handler instanceof HandlerMethod) {
                    String methodName = ((HandlerMethod)handler).getMethod().getName();
                    span.tag(TraceWebFilter.MVC_CONTROLLER_METHOD_KEY, methodName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
                    }
                }
            }

            private void addClassNameTag(Object handler, Span span) {
                if (handler == null) {
                    return;
                }
                String className = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
                }
                span.tag(TraceWebFilter.MVC_CONTROLLER_CLASS_KEY, className);
            }

            private void addResponseTagsForSpanWithoutParent(ServerWebExchange exchange, ServerHttpResponse response, Span span) {
                if (this.spanWithoutParent(exchange) && response.getStatusCode() != null && span != null) {
                    span.tag(TraceWebFilter.STATUS_CODE_KEY, String.valueOf(response.getStatusCode().value()));
                }
            }

            private boolean spanWithoutParent(ServerWebExchange exchange) {
                return exchange.getAttribute(TRACE_SPAN_WITHOUT_PARENT) != null;
            }
        }
    }
}

