/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class TraceAsyncListenableTaskExecutor
implements AsyncListenableTaskExecutor {
    private final AsyncListenableTaskExecutor delegate;
    private final Tracer tracer;
    private final SpanNamer spanNamer;

    TraceAsyncListenableTaskExecutor(AsyncListenableTaskExecutor delegate, Tracer tracer, SpanNamer spanNamer) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.spanNamer = spanNamer;
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable((Runnable)new TraceRunnable(this.tracer, this.spanNamer, task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable(new TraceCallable<T>(this.tracer, this.spanNamer, task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute((Runnable)new TraceRunnable(this.tracer, this.spanNamer, task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit((Runnable)new TraceRunnable(this.tracer, this.spanNamer, task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(new TraceCallable<T>(this.tracer, this.spanNamer, task));
    }

    public void execute(Runnable task) {
        this.delegate.execute((Runnable)new TraceRunnable(this.tracer, this.spanNamer, task));
    }
}

