/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.cloud.sleuth.stream.Spans;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.MessageEndpoint;

@MessageEndpoint
public class StreamSpanReporter
implements SpanReporter {
    private BlockingQueue<Span> queue = new LinkedBlockingQueue<Span>();
    private final HostLocator endpointLocator;
    private final SpanMetricReporter spanMetricReporter;

    public StreamSpanReporter(HostLocator endpointLocator, SpanMetricReporter spanMetricReporter) {
        this.endpointLocator = endpointLocator;
        this.spanMetricReporter = spanMetricReporter;
    }

    public void setQueue(BlockingQueue<Span> queue) {
        this.queue = queue;
    }

    @InboundChannelAdapter(value="sleuth")
    public Spans poll() {
        ArrayList<Span> result = new ArrayList<Span>();
        this.queue.drainTo(result);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Span span = (Span)iterator.next();
            if (span.getName() == null || !span.getName().equals("message/sleuth")) continue;
            iterator.remove();
        }
        if (result.isEmpty()) {
            return null;
        }
        this.spanMetricReporter.incrementAcceptedSpans((long)result.size());
        return new Spans(this.endpointLocator.locate((Span)result.get(0)), result);
    }

    public void report(Span span) {
        if (span.isExportable()) {
            this.queue.add(span);
        }
    }
}

