/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.annotation.Pair;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import reactor.core.publisher.Mono;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class SleuthSpanCreatorAspectMonoTests {
    @Autowired
    TestBeanInterface testBean;
    @Autowired
    TestBeanOuter testBeanOuter;
    @Autowired
    Tracer tracer;
    @Autowired
    TestSpanHandler spans;

    protected static String id(Tracer tracer) {
        if (tracer.currentSpan() == null) {
            throw new IllegalStateException("Current Span is supposed to have a value!");
        }
        return tracer.currentSpan().context().spanId();
    }

    @BeforeEach
    public void setup() {
        this.spans.clear();
        this.tracer.withSpan(null);
    }

    @Test
    public void shouldCreateSpanWhenAnnotationOnInterfaceMethod() {
        Mono<String> mono = this.testBean.testMethod();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWhenAnnotationOnClassMethod() {
        Mono<String> mono = this.testBean.testMethod2();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method2");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithCustomNameWhenAnnotationOnClassMethod() {
        Mono<String> mono = this.testBean.testMethod3();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        String result = (String)mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((String)result).isEqualTo("Test String");
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method3");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithCustomNameWhenAnnotationOnInterfaceMethod() {
        Mono<String> mono = this.testBean.testMethod4();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method4");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithTagWhenAnnotationOnInterfaceMethod() {
        Mono<String> mono = this.testBean.testMethod5("test");
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method5");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag", (Object)"test");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithTagWhenAnnotationOnClassMethod() {
        Mono<String> mono = this.testBean.testMethod6("test");
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method6");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag6", (Object)"test");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithLogWhenAnnotationOnInterfaceMethod() {
        Mono<String> mono = this.testBean.testMethod8("test");
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method8");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithLogWhenAnnotationOnClassMethod() {
        Mono<String> mono = this.testBean.testMethod9("test");
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method9");
            ((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"class", (Object)"TestBean")).containsEntry((Object)"method", (Object)"testMethod9");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWithLogWhenAnnotationOnInterfaceMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Mono<String> mono = this.testBean.testMethod10("test");
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            mono.block();
        }
        finally {
            span.end();
        }
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldStartAndCloseSpanOnContinueSpanIfSpanNotSet() {
        this.testBean.testMethod10("test").block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method10");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWhenKeyIsUsedOnSpanTagWhenAnnotationOnInterfaceMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Mono<String> mono = this.testBean.testMethod10_v2("test");
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            mono.block();
        }
        finally {
            span.end();
        }
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWithLogWhenAnnotationOnClassMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Mono<String> mono = this.testBean.testMethod11("test");
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            mono.block();
        }
        finally {
            span.end();
        }
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            ((MapAssert)((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"class", (Object)"TestBean")).containsEntry((Object)"method", (Object)"testMethod11")).containsEntry((Object)"customTestTag11", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldAddErrorTagWhenExceptionOccurredInNewSpan() {
        try {
            Mono<String> mono = this.testBean.testMethod12("test");
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            mono.block();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method12");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag12", (Object)"test");
            BDDAssertions.then((Throwable)this.spans.get(0).getError()).hasMessageContaining("test exception 12");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddErrorTagWhenExceptionOccurredInContinueSpan() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Mono<String> mono = this.testBean.testMethod13();
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            mono.block();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            span.end();
        }
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            BDDAssertions.then((Throwable)this.spans.get(0).getError()).hasMessageContaining("test exception 13");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"testMethod13.before", "testMethod13.afterFailure", "testMethod13.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldNotCreateSpanWhenNotAnnotated() {
        Mono<String> mono = this.testBean.testMethod7();
        mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldReturnNewSpanFromTraceContext() {
        Mono<String> mono = this.testBean.newSpanInTraceContext();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        String newSpanId = (String)mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("span-in-trace-context");
            BDDAssertions.then((String)this.spans.get(0).getSpanId()).isEqualTo(newSpanId);
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldReturnNewSpanFromTraceContextOuter() {
        Mono<Pair<Pair<String, String>, String>> mono = this.testBeanOuter.outerNewSpanInTraceContext();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        Pair pair = (Pair)mono.block();
        String outerSpanIdBefore = (String)((Pair)pair.getFirst()).getFirst();
        String innerSpanId = (String)pair.getSecond();
        BDDAssertions.then((String)outerSpanIdBefore).isNotEqualTo((Object)innerSpanId);
        Awaitility.await().untilAsserted(() -> {
            FinishedSpan outerSpan = this.spans.reportedSpans().stream().filter(span -> span.getName().equals("outer-span-in-trace-context")).findFirst().orElseThrow(() -> new AssertionError((Object)"No span with name [outer-span-in-trace-context] found"));
            BDDAssertions.then((String)outerSpan.getName()).isEqualTo("outer-span-in-trace-context");
            BDDAssertions.then((String)outerSpan.getSpanId()).isEqualTo(outerSpanIdBefore);
            FinishedSpan innerSpan = this.spans.reportedSpans().stream().filter(span -> span.getName().equals("span-in-trace-context")).findFirst().orElseThrow(() -> new AssertionError((Object)"No span with name [span-in-trace-context] found"));
            BDDAssertions.then((String)innerSpan.getName()).isEqualTo("span-in-trace-context");
            BDDAssertions.then((String)innerSpan.getSpanId()).isEqualTo(innerSpanId);
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldReturnNewSpanFromSubscriberContext() {
        Mono<String> mono = this.testBean.newSpanInSubscriberContext();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        String newSpanId = (String)mono.block();
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("span-in-subscriber-context");
            BDDAssertions.then((String)this.spans.get(0).getSpanId()).isEqualTo(newSpanId);
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldReturnNewSpanFromSubscriberContextOuter() {
        Mono<Pair<Pair<String, String>, String>> mono = this.testBeanOuter.outerNewSpanInSubscriberContext();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        Pair pair = (Pair)mono.block();
        String outerSpanIdBefore = (String)((Pair)pair.getFirst()).getFirst();
        String innerSpanId = (String)pair.getSecond();
        BDDAssertions.then((String)outerSpanIdBefore).isNotEqualTo((Object)innerSpanId);
        Awaitility.await().untilAsserted(() -> {
            FinishedSpan outerSpan = this.spans.reportedSpans().stream().filter(span -> span.getName().equals("outer-span-in-subscriber-context")).findFirst().orElseThrow(() -> new AssertionError((Object)"No span with name [outer-span-in-subscriber-context] found"));
            BDDAssertions.then((String)outerSpan.getName()).isEqualTo("outer-span-in-subscriber-context");
            BDDAssertions.then((String)outerSpan.getSpanId()).isEqualTo(outerSpanIdBefore);
            FinishedSpan innerSpan = this.spans.reportedSpans().stream().filter(span -> span.getName().equals("span-in-subscriber-context")).findFirst().orElseThrow(() -> new AssertionError((Object)"No span with name [span-in-subscriber-context] found"));
            BDDAssertions.then((String)innerSpan.getName()).isEqualTo("span-in-subscriber-context");
            BDDAssertions.then((String)innerSpan.getSpanId()).isEqualTo(innerSpanId);
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfiguration {
        @Bean
        TestBeanInterface testBean(Tracer tracer) {
            return new TestBean(tracer);
        }

        @Bean
        TestBeanOuter testBeanOuter(Tracer tracer, TestBeanInterface testBean) {
            return new TestBeanOuter(tracer, testBean);
        }
    }

    protected static class TestBeanOuter {
        private final Tracer tracer;
        private final TestBeanInterface testBeanInterface;

        public TestBeanOuter(Tracer tracer, TestBeanInterface testBeanInterface) {
            this.tracer = tracer;
            this.testBeanInterface = testBeanInterface;
        }

        @NewSpan(name="outerSpanInTraceContext")
        public Mono<Pair<Pair<String, String>, String>> outerNewSpanInTraceContext() {
            return Mono.defer(() -> Mono.just((Object)SleuthSpanCreatorAspectMonoTests.id(this.tracer)).zipWith(this.testBeanInterface.newSpanInTraceContext()).map(pair -> Pair.of(Pair.of((String)pair.getT1(), SleuthSpanCreatorAspectMonoTests.id(this.tracer)), (String)pair.getT2())));
        }

        @NewSpan(name="outerSpanInSubscriberContext")
        public Mono<Pair<Pair<String, String>, String>> outerNewSpanInSubscriberContext() {
            return Mono.subscriberContext().flatMap(context -> Mono.just((Object)SleuthSpanCreatorAspectMonoTests.id(this.tracer)).zipWith(this.testBeanInterface.newSpanInSubscriberContext()).map(pair -> Pair.of(Pair.of((String)pair.getT1(), SleuthSpanCreatorAspectMonoTests.id(this.tracer)), (String)pair.getT2())));
        }
    }

    protected static class TestBean
    implements TestBeanInterface {
        public static final String TEST_STRING = "Test String";
        public static final Mono<String> TEST_MONO = Mono.defer(() -> Mono.just((Object)TEST_STRING));
        private final Tracer tracer;

        public TestBean(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public Mono<String> testMethod() {
            return TEST_MONO;
        }

        @Override
        @NewSpan
        public Mono<String> testMethod2() {
            return TEST_MONO;
        }

        @Override
        @NewSpan(name="customNameOnTestMethod3")
        public Mono<String> testMethod3() {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod4() {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod5(String test) {
            return TEST_MONO;
        }

        @Override
        @NewSpan(name="customNameOnTestMethod6")
        public Mono<String> testMethod6(@SpanTag(value="testTag6") String test) {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod7() {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod8(String param) {
            return TEST_MONO;
        }

        @Override
        @NewSpan(name="customNameOnTestMethod9")
        public Mono<String> testMethod9(String param) {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod10(@SpanTag(value="customTestTag10") String param) {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod10_v2(@SpanTag(key="customTestTag10") String param) {
            return TEST_MONO;
        }

        @Override
        @ContinueSpan(log="customTest")
        public Mono<String> testMethod11(@SpanTag(value="customTestTag11") String param) {
            return TEST_MONO;
        }

        @Override
        public Mono<String> testMethod12(String param) {
            return Mono.defer(() -> Mono.error((Throwable)new RuntimeException("test exception 12")));
        }

        @Override
        public Mono<String> testMethod13() {
            return Mono.defer(() -> Mono.error((Throwable)new RuntimeException("test exception 13")));
        }

        @Override
        public Mono<String> newSpanInTraceContext() {
            return Mono.defer(() -> Mono.just((Object)SleuthSpanCreatorAspectMonoTests.id(this.tracer)));
        }

        @Override
        public Mono<String> newSpanInSubscriberContext() {
            return Mono.subscriberContext().flatMap(context -> Mono.just((Object)SleuthSpanCreatorAspectMonoTests.id(this.tracer)));
        }
    }

    protected static interface TestBeanInterface {
        @NewSpan
        public Mono<String> testMethod();

        public Mono<String> testMethod2();

        @NewSpan(name="interfaceCustomNameOnTestMethod3")
        public Mono<String> testMethod3();

        @NewSpan(value="customNameOnTestMethod4")
        public Mono<String> testMethod4();

        @NewSpan(name="customNameOnTestMethod5")
        public Mono<String> testMethod5(@SpanTag(value="testTag") String var1);

        public Mono<String> testMethod6(String var1);

        public Mono<String> testMethod7();

        @NewSpan(name="customNameOnTestMethod8")
        public Mono<String> testMethod8(String var1);

        @NewSpan(name="testMethod9")
        public Mono<String> testMethod9(String var1);

        @ContinueSpan(log="customTest")
        public Mono<String> testMethod10(@SpanTag(value="testTag10") String var1);

        @ContinueSpan(log="customTest")
        public Mono<String> testMethod10_v2(@SpanTag(key="testTag10") String var1);

        @ContinueSpan(log="testMethod11")
        public Mono<String> testMethod11(@SpanTag(value="testTag11") String var1);

        @NewSpan
        public Mono<String> testMethod12(@SpanTag(value="testTag12") String var1);

        @ContinueSpan(log="testMethod13")
        public Mono<String> testMethod13();

        @NewSpan(name="spanInTraceContext")
        public Mono<String> newSpanInTraceContext();

        @NewSpan(name="spanInSubscriberContext")
        public Mono<String> newSpanInSubscriberContext();
    }
}

