/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskExecutor;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListenerAccessor;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class TraceThreadPoolTaskExecutorTests
implements TestTracingAwareSupplier {
    ThreadPoolTaskExecutor delegate = new ThreadPoolTaskExecutor();
    BeanFactory beanFactory = this.beanFactory();
    LazyTraceThreadPoolTaskExecutor traceThreadPoolTaskExecutor = new LazyTraceThreadPoolTaskExecutor(this.beanFactory, this.delegate);

    @BeforeEach
    void setup() {
        this.delegate.initialize();
        SleuthContextListenerAccessor.set(this.beanFactory, true);
    }

    @AfterEach
    void clear() {
        this.delegate.shutdown();
    }

    private BeanFactory beanFactory() {
        BeanFactory beanFactory = (BeanFactory)BDDMockito.mock(BeanFactory.class);
        BDDMockito.given((Object)((Tracer)beanFactory.getBean(Tracer.class))).willReturn((Object)this.tracerTest().tracing().tracer());
        BDDMockito.given((Object)((SpanNamer)beanFactory.getBean(SpanNamer.class))).willReturn((Object)new DefaultSpanNamer());
        return beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_create_thread_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.createThread(this.aRunnable(executed, span)).start();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_listenable_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.submitListenable(this.aRunnable(executed, span)).get();
        }
        finally {
            span.end();
        }
        BDDAssertions.then((boolean)executed.get()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_listenable_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceThreadPoolTaskExecutor.submitListenable(this.aCallable(span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.execute(this.aRunnable(executed, span));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_with_timeout_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.execute(this.aRunnable(executed, span), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceThreadPoolTaskExecutor.submit(this.aCallable(span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable_via_new_thread() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.newThread(this.aRunnable(executed, span)).start();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable_via_create_thread() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.createThread(this.aRunnable(executed, span)).start();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    Runnable aRunnable(AtomicBoolean executed, Span currentSpan) {
        return () -> {
            Span span = this.tracerTest().tracing().tracer().currentSpan();
            BDDAssertions.then((Object)span).isNotNull();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(currentSpan.context().traceId());
            executed.set(true);
        };
    }

    Callable<Span> aCallable(Span currentSpan) {
        return () -> {
            Span span = this.tracerTest().tracing().tracer().currentSpan();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(currentSpan.context().traceId());
            return span;
        };
    }
}

