/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskScheduler;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListenerAccessor;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class TraceThreadPoolTaskSchedulerTests
implements TestTracingAwareSupplier {
    ThreadPoolTaskScheduler delegate = new ThreadPoolTaskScheduler();
    BeanFactory beanFactory = this.beanFactory();
    LazyTraceThreadPoolTaskScheduler traceThreadPoolTaskExecutor = new LazyTraceThreadPoolTaskScheduler(this.beanFactory, this.delegate, "foo");

    @BeforeEach
    void setup() {
        this.delegate.initialize();
        SleuthContextListenerAccessor.set(this.beanFactory, true);
    }

    @AfterEach
    void clear() {
        this.delegate.shutdown();
        this.traceThreadPoolTaskExecutor.shutdown();
    }

    private BeanFactory beanFactory() {
        BeanFactory beanFactory = (BeanFactory)BDDMockito.mock(BeanFactory.class);
        BDDMockito.given((Object)((Tracer)beanFactory.getBean(Tracer.class))).willReturn((Object)this.tracerTest().tracing().tracer());
        BDDMockito.given((Object)((SpanNamer)beanFactory.getBean(SpanNamer.class))).willReturn((Object)new DefaultSpanNamer());
        return beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_initialize_wrapped_executor() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            ExecutorService executorService = this.traceThreadPoolTaskExecutor.initializeExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r);
                }
            }, new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                }
            });
            executorService.submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
            executorService.shutdown();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_create_wrapped_executor() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.createExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r);
                }
            }, new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                }
            }).submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_get_scheduled_wrapped_executor() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.getScheduledExecutor().submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_get_scheduled_thread_pool_wrapped_executor() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.getScheduledThreadPoolExecutor().submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_create_thread_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.createThread(this.aRunnable(executed, span)).start();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.schedule(this.aRunnable(executed, span), Instant.now()).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((boolean)executed.get()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_trace_runnable_with_start_time() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.schedule(this.aRunnable(executed, span), Date.from(Instant.now())).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((boolean)executed.get()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_trace_runnable_with_trigger() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.schedule(this.aRunnable(executed, span), new Trigger(){

                public java.util.Date nextExecutionTime(TriggerContext triggerContext) {
                    return java.util.Date.from(Instant.now());
                }
            }).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((boolean)executed.get()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_at_fixed_rate_trace_runnable_with_date() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleAtFixedRate(this.aRunnable(executed, span), Date.from(Instant.now()), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_at_fixed_rate_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleAtFixedRate(this.aRunnable(executed, span), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_at_fixed_rate_trace_runnable_with_instant() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleAtFixedRate(this.aRunnable(executed, span), Instant.now(), Duration.ofMillis(10L));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_at_fixed_rate_trace_runnable_with_duration() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleAtFixedRate(this.aRunnable(executed, span), Duration.ofMillis(10L));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_with_fixed_delay_trace_runnable_with_date() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleWithFixedDelay(this.aRunnable(executed, span), Date.from(Instant.now()), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_with_fixed_delay_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleWithFixedDelay(this.aRunnable(executed, span), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_with_fixed_delay_trace_runnable_with_instant() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleWithFixedDelay(this.aRunnable(executed, span), Instant.now(), Duration.ofMillis(10L));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_schedule_with_fixed_delay_trace_runnable_with_duration() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.scheduleWithFixedDelay(this.aRunnable(executed, span), Duration.ofMillis(10L));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_listenable_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.submitListenable(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_listenable_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceThreadPoolTaskExecutor.submitListenable(this.aCallable(span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.execute(this.aRunnable(executed, span));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_with_timeout_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.execute(this.aRunnable(executed, span), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceThreadPoolTaskExecutor.submit(this.aCallable(span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.submit(this.aRunnable(executed, span)).get(1L, TimeUnit.SECONDS);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable_via_new_thread() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.newThread(this.aRunnable(executed, span)).start();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable_via_create_thread() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceThreadPoolTaskExecutor.createThread(this.aRunnable(executed, span)).start();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    Runnable aRunnable(AtomicBoolean executed, Span currentSpan) {
        return () -> {
            Span span = this.tracerTest().tracing().tracer().currentSpan();
            BDDAssertions.then((Object)span).isNotNull();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(currentSpan.context().traceId());
            executed.set(true);
        };
    }

    Callable<Span> aCallable(Span currentSpan) {
        return () -> {
            Span span = this.tracerTest().tracing().tracer().currentSpan();
            BDDAssertions.then((String)span.context().traceId()).isEqualTo(currentSpan.context().traceId());
            return span;
        };
    }
}

