/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListenerAccessor;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class TraceableExecutorServiceTests
implements TestTracingAwareSupplier {
    private static int TOTAL_THREADS = 10;
    @Mock(lenient=true)
    BeanFactory beanFactory;
    ExecutorService executorService = Executors.newFixedThreadPool(3);
    TraceableExecutorService traceManagerableExecutorService;
    SpanVerifyingRunnable spanVerifyingRunnable = new SpanVerifyingRunnable();
    Tracer tracer = this.tracerTest().tracing().tracer();
    CurrentTraceContext currentTraceContext = this.tracerTest().tracing().currentTraceContext();

    @BeforeEach
    public void setup() {
        this.traceManagerableExecutorService = new TraceableExecutorService(this.beanFactory(true), this.executorService, "foo");
        this.spanVerifyingRunnable.clear();
    }

    @AfterEach
    public void tearDown() {
        this.traceManagerableExecutorService.shutdown();
        this.executorService.shutdown();
    }

    @Test
    public void should_propagate_trace_id_and_set_new_span_when_traceable_executor_service_is_executed() throws Exception {
        ScopedSpan span = this.tracer.startScopedSpan("http:PARENT");
        try {
            CompletableFuture.allOf(this.runnablesExecutedViaTraceManagerableExecutorService()).get();
        }
        finally {
            span.end();
        }
        BDDAssertions.then(this.spanVerifyingRunnable.traceIds.stream().distinct().collect(Collectors.toList())).hasSize(1);
        BDDAssertions.then(this.spanVerifyingRunnable.spanIds.stream().distinct().collect(Collectors.toList())).hasSize(TOTAL_THREADS);
    }

    @Test
    public void should_wrap_methods_in_trace_representation_only_for_non_tracing_callables() throws Exception {
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        TraceableExecutorService traceExecutorService = new TraceableExecutorService(this.beanFactory(true), executorService);
        traceExecutorService.invokeAll((Collection)this.callables());
        ((ExecutorService)BDDMockito.then((Object)executorService).should()).invokeAll((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()));
        traceExecutorService.invokeAll((Collection)this.callables(), 1L, TimeUnit.DAYS);
        ((ExecutorService)BDDMockito.then((Object)executorService).should()).invokeAll((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()), BDDMockito.eq((long)1L), (TimeUnit)((Object)BDDMockito.eq((Object)((Object)TimeUnit.DAYS))));
        traceExecutorService.invokeAny((Collection)this.callables());
        ((ExecutorService)BDDMockito.then((Object)executorService).should()).invokeAny((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()));
        traceExecutorService.invokeAny((Collection)this.callables(), 1L, TimeUnit.DAYS);
        ((ExecutorService)BDDMockito.then((Object)executorService).should()).invokeAny((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()), BDDMockito.eq((long)1L), (TimeUnit)((Object)BDDMockito.eq((Object)((Object)TimeUnit.DAYS))));
    }

    @Test
    public void should_not_wrap_methods_in_trace_representation_only_for_non_tracing_callables_when_context_not_ready() throws Exception {
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        TraceableExecutorService traceExecutorService = new TraceableExecutorService(this.beanFactory(false), executorService);
        traceExecutorService.invokeAll((Collection)this.callables());
        ((ExecutorService)BDDMockito.then((Object)executorService).should(BDDMockito.never())).invokeAll((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()));
        traceExecutorService.invokeAll((Collection)this.callables(), 1L, TimeUnit.DAYS);
        ((ExecutorService)BDDMockito.then((Object)executorService).should(BDDMockito.never())).invokeAll((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()), BDDMockito.eq((long)1L), (TimeUnit)((Object)BDDMockito.eq((Object)((Object)TimeUnit.DAYS))));
        traceExecutorService.invokeAny((Collection)this.callables());
        ((ExecutorService)BDDMockito.then((Object)executorService).should(BDDMockito.never())).invokeAny((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()));
        traceExecutorService.invokeAny((Collection)this.callables(), 1L, TimeUnit.DAYS);
        ((ExecutorService)BDDMockito.then((Object)executorService).should(BDDMockito.never())).invokeAny((Collection)BDDMockito.argThat(this.withSpanContinuingTraceCallablesOnly()), BDDMockito.eq((long)1L), (TimeUnit)((Object)BDDMockito.eq((Object)((Object)TimeUnit.DAYS))));
    }

    private ArgumentMatcher<Collection<? extends Callable<Object>>> withSpanContinuingTraceCallablesOnly() {
        return argument -> {
            try {
                BDDAssertions.then((Collection)argument).flatExtracting(new ThrowingExtractor[]{Object::getClass}).containsOnlyElementsOf(Collections.singletonList(TraceCallable.class));
            }
            catch (AssertionError e) {
                return false;
            }
            return true;
        };
    }

    private List callables() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new TraceCallable(this.tracer, (SpanNamer)new DefaultSpanNamer(), () -> "foo"));
        list.add(() -> "bar");
        return list;
    }

    @Test
    public void should_propagate_trace_info_when_compleable_future_is_used() throws Exception {
        ExecutorService executorService = this.executorService;
        BeanFactory beanFactory = this.beanFactory(true);
        CompletableFuture<Long> completableFuture = CompletableFuture.supplyAsync(() -> 1000000L, (Executor)new TraceableExecutorService(beanFactory, executorService, "calculateTax"));
        BDDAssertions.then((Long)completableFuture.get()).isEqualTo(1000000L);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void should_remove_entries_from_cache_when_executor_service_shutsdown() throws Exception {
        BDDAssertions.then((Map)TraceableExecutorService.CACHE).doesNotContainKey((Object)this.executorService);
        TraceableExecutorService.wrap((BeanFactory)this.beanFactory, (ExecutorService)this.executorService, (String)"foo").shutdown();
        BDDAssertions.then((Map)TraceableExecutorService.CACHE).doesNotContainKey((Object)this.executorService);
        TraceableExecutorService.wrap((BeanFactory)this.beanFactory, (ExecutorService)this.executorService, (String)"foo").shutdownNow();
        BDDAssertions.then((Map)TraceableExecutorService.CACHE).doesNotContainKey((Object)this.executorService);
    }

    @Test
    public void should_not_propagate_trace_info_when_compleable_future_is_used_when_context_not_refreshed() throws Exception {
        ExecutorService executorService = this.executorService;
        BeanFactory beanFactory = this.beanFactory(false);
        CompletableFuture<Long> completableFuture = CompletableFuture.supplyAsync(() -> 1000000L, (Executor)new TraceableExecutorService(beanFactory, executorService, "calculateTax"));
        BDDAssertions.then((Long)completableFuture.get()).isEqualTo(1000000L);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    private CompletableFuture<?>[] runnablesExecutedViaTraceManagerableExecutorService() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int i = 0; i < TOTAL_THREADS; ++i) {
            futures.add(CompletableFuture.runAsync(this.spanVerifyingRunnable, (Executor)this.traceManagerableExecutorService));
        }
        return futures.toArray(new CompletableFuture[futures.size()]);
    }

    BeanFactory beanFactory(boolean refreshed) {
        BDDMockito.given((Object)((Tracer)this.beanFactory.getBean(Tracer.class))).willReturn((Object)this.tracer);
        BDDMockito.given((Object)((SpanNamer)this.beanFactory.getBean(SpanNamer.class))).willReturn((Object)new DefaultSpanNamer());
        SleuthContextListenerAccessor.set(this.beanFactory, refreshed);
        return this.beanFactory;
    }

    class SpanVerifyingRunnable
    implements Runnable {
        Queue<String> traceIds = new ConcurrentLinkedQueue<String>();
        Queue<String> spanIds = new ConcurrentLinkedQueue<String>();

        SpanVerifyingRunnable() {
        }

        @Override
        public void run() {
            TraceContext context = TraceableExecutorServiceTests.this.currentTraceContext.context();
            this.traceIds.add(context.traceId());
            this.spanIds.add(context.spanId());
        }

        void clear() {
            this.traceIds.clear();
            this.spanIds.clear();
        }
    }
}

