/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceReactiveCircuitBreaker;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import reactor.core.publisher.Mono;

public abstract class ReactiveCircuitBreakerTests
implements TestTracingAwareSupplier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_pass_tracing_information_when_using_circuit_breaker() {
        Tracer tracer = this.tracerTest().tracing().tracer();
        ScopedSpan scopedSpan = null;
        try {
            scopedSpan = tracer.startScopedSpan("start");
            Span span = (Span)new TraceReactiveCircuitBreaker(new ReactiveResilience4JCircuitBreakerFactory().create("name"), tracer, this.tracerTest().tracing().currentTraceContext()).run(Mono.defer(() -> Mono.just((Object)tracer.currentSpan()))).block();
            BDDAssertions.then((Object)span).isNotNull();
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(span.context().traceId());
        }
        finally {
            scopedSpan.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_pass_tracing_information_when_using_circuit_breaker_with_fallback() {
        Tracer tracer = this.tracerTest().tracing().tracer();
        AtomicReference first = new AtomicReference();
        AtomicReference second = new AtomicReference();
        ScopedSpan scopedSpan = null;
        try {
            scopedSpan = tracer.startScopedSpan("start");
            ((AbstractThrowableAssert)BDDAssertions.thenThrownBy(() -> new TraceReactiveCircuitBreaker(new ReactiveResilience4JCircuitBreakerFactory().create("name"), tracer, this.tracerTest().tracing().currentTraceContext()).run(Mono.defer(() -> {
                first.set(tracer.currentSpan());
                throw new IllegalStateException("boom");
            }), throwable -> {
                second.set(tracer.currentSpan());
                throw new IllegalStateException("boom2");
            }).block()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("boom2");
            BDDAssertions.then(this.tracerTest().handler().reportedSpans()).hasSize(2);
            BDDAssertions.then((Object)((Span)first.get())).isNotNull();
            BDDAssertions.then((Object)((Span)second.get())).isNotNull();
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(((Span)first.get()).context().traceId());
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(((Span)second.get()).context().traceId());
            BDDAssertions.then((String)((Span)first.get()).context().spanId()).isNotEqualTo((Object)((Span)second.get()).context().spanId());
            FinishedSpan finishedSpan = this.tracerTest().handler().reportedSpans().get(1);
            BDDAssertions.then((String)finishedSpan.getName()).contains(new CharSequence[]{"function"});
            this.additionalAssertions(finishedSpan);
        }
        finally {
            scopedSpan.end();
        }
    }

    public void additionalAssertions(FinishedSpan finishedSpan) {
        throw new UnsupportedOperationException("Assert errors");
    }
}

