/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.presentation.StandardRepresentation;
import org.junit.Test;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public abstract class ScopePassingSpanSubscriberTests {
    Subscriber<Object> assertNotScopePassingSpanSubscriber = new CoreSubscriber<Object>(){

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
            Assertions.assertThat((Object)s).isNotInstanceOf(ScopePassingSpanSubscriber.class);
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };
    Subscriber<Object> assertScopePassingSpanSubscriber = new CoreSubscriber<Object>(){

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
            Assertions.assertThat((Object)s).isInstanceOf(ScopePassingSpanSubscriber.class);
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };
    Subscriber<Object> exceptionThrowingPassingSpanSubscriber = new CoreSubscriber<Object>(){

        public void onSubscribe(Subscription s) {
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }

        public Context currentContext() {
            throw new NullPointerException("Boom!");
        }
    };
    AnnotationConfigApplicationContext springContext = new AnnotationConfigApplicationContext();

    protected abstract CurrentTraceContext currentTraceContext();

    protected abstract TraceContext context();

    protected abstract TraceContext context2();

    @BeforeEach
    public void resetHooks() {
        Hooks.resetOnEachOperator((String)"org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration.TraceReactorConfiguration");
        Hooks.resetOnLastOperator((String)"org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration.TraceReactorConfiguration");
        Schedulers.resetOnScheduleHook((String)"sleuth");
    }

    @AfterEach
    public void close() {
        this.springContext.close();
    }

    @org.junit.jupiter.api.Test
    public void should_propagate_current_context() {
        ScopePassingSpanSubscriber subscriber = new ScopePassingSpanSubscriber(null, Context.of((Object)"foo", (Object)"bar"), this.currentTraceContext(), null);
        BDDAssertions.then((String)((String)subscriber.currentContext().get((Object)"foo"))).isEqualTo("bar");
    }

    @org.junit.jupiter.api.Test
    public void should_not_redundantly_copy_context() {
        Context initial = Context.of(TraceContext.class, (Object)this.context());
        ScopePassingSpanSubscriber subscriber = new ScopePassingSpanSubscriber(null, initial, this.currentTraceContext(), this.context());
        BDDAssertions.then((Object)((TraceContext)initial.get(TraceContext.class))).isSameAs(subscriber.currentContext().get(TraceContext.class));
    }

    @org.junit.jupiter.api.Test
    public void should_set_empty_context_when_context_is_null() {
        ScopePassingSpanSubscriber subscriber = new ScopePassingSpanSubscriber(null, Context.empty(), this.currentTraceContext(), null);
        BDDAssertions.then((boolean)subscriber.currentContext().isEmpty()).isTrue();
    }

    @Test
    public void should_set_empty_context_when_exception_occurs_while_trying_to_retrieve_the_context() {
        ScopePassingSpanSubscriber subscriber = new ScopePassingSpanSubscriber(null, Context.empty(), this.currentTraceContext(), null);
        BDDAssertions.then((boolean)subscriber.currentContext().isEmpty()).isTrue();
    }

    @org.junit.jupiter.api.Test
    public void should_put_current_span_to_context() {
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context2());){
            ScopePassingSpanSubscriber subscriber = new ScopePassingSpanSubscriber((Subscriber)new BaseSubscriber<Object>(){}, Context.empty(), this.currentTraceContext(), this.context());
            BDDAssertions.then((Object)((TraceContext)subscriber.currentContext().get(TraceContext.class))).isEqualTo((Object)this.context());
        }
    }

    @org.junit.jupiter.api.Test
    public void should_not_scope_scalar_subscribe() {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Function transformer = ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)this.springContext);
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            ((Publisher)transformer.apply(Mono.just((Object)1))).subscribe(this.assertNotScopePassingSpanSubscriber);
            ((Publisher)transformer.apply(Mono.error((Throwable)new Exception()))).subscribe(this.assertNotScopePassingSpanSubscriber);
            ((Publisher)transformer.apply(Mono.empty())).subscribe(this.assertNotScopePassingSpanSubscriber);
        }
    }

    @org.junit.jupiter.api.Test
    public void should_scope_scalar_hide_subscribe() {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Function transformer = ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)this.springContext);
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            ((Publisher)transformer.apply(Mono.just((Object)1).hide())).subscribe(this.assertScopePassingSpanSubscriber);
            ((Publisher)transformer.apply(Mono.error((Throwable)new Exception()).hide())).subscribe(this.assertScopePassingSpanSubscriber);
            ((Publisher)transformer.apply(Mono.empty().hide())).subscribe(this.assertScopePassingSpanSubscriber);
        }
    }

    static {
        StandardRepresentation.registerFormatterForType(ScopePassingSpanSubscriber.class, Objects::toString);
    }
}

