/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.redis;

import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.tracing.Tracing;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.redis.TraceLettuceClientResourcesBuilderCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.sleuth.redis.remote-service-name=redis-foo"})
public abstract class LettuceIntegrationTests {
    @Autowired(required=false)
    ClientResources clientResources;
    @Autowired
    TraceLettuceClientResourcesBuilderCustomizer customizer;
    @Autowired
    Tracing tracing;

    @Test
    void tracing_should_be_set() {
        BDDAssertions.then((Object)this.clientResources).isNull();
        BDDAssertions.then((Object)this.customizer).isNotNull();
        BDDAssertions.then((boolean)this.tracing.isEnabled()).isTrue();
        BDDAssertions.then((Object)this.tracing).isInstanceOf(this.tracing());
    }

    protected abstract Class<? extends Tracing> tracing();

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    protected static class TestConfig {
        protected TestConfig() {
        }
    }
}

