/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import io.netty.handler.codec.http.HttpResponseStatus;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.PrematureCloseException;
import reactor.netty.http.server.HttpServer;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class ReactorNettyHttpClientSpringBootTests {
    DisposableServer disposableServer;
    @Autowired
    HttpClient httpClient;
    @Autowired
    CurrentTraceContext currentTraceContext;
    @Autowired
    TestSpanHandler handler;
    TraceContext parent = this.traceContext();

    @AfterEach
    public void tearDown() {
        if (this.disposableServer != null) {
            this.disposableServer.disposeNow();
        }
        this.handler.clear();
    }

    public abstract TraceContext traceContext();

    @Test
    public void shouldRecordRemoteEndpoint() throws Exception {
        this.disposableServer = HttpServer.create().port(0).handle((in, out) -> out.sendString((Publisher)Flux.just((Object)"foo"))).bindNow();
        HttpClientResponse response = (HttpClientResponse)((HttpClient.ResponseReceiver)this.httpClient.port(this.disposableServer.port()).get().uri("/")).response().block();
        Assertions.assertThat((Comparable)response.status()).isEqualTo((Object)HttpResponseStatus.OK);
        FinishedSpan clientSpan = this.handler.takeRemoteSpan(Span.Kind.CLIENT);
        Assertions.assertThat((String)clientSpan.getRemoteIp()).isNotNull();
        Assertions.assertThat((int)clientSpan.getRemotePort()).isNotZero();
    }

    @Test
    public void shouldUseInvocationContext() throws Exception {
        String b3SingleHeaderReadByServer;
        this.disposableServer = HttpServer.create().port(0).handle((in, out) -> out.sendString((Publisher)Flux.just((Object)in.requestHeaders().get("b3")))).bindNow();
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.newScope(this.parent);){
            b3SingleHeaderReadByServer = (String)((HttpClient.ResponseReceiver)this.httpClient.port(this.disposableServer.port()).get().uri("/")).responseContent().aggregate().asString().block();
        }
        FinishedSpan clientSpan = this.handler.takeRemoteSpan(Span.Kind.CLIENT);
        this.assertSingleB3Header(b3SingleHeaderReadByServer, clientSpan, this.parent);
    }

    public void assertSingleB3Header(String b3SingleHeaderReadByServer, FinishedSpan clientSpan, TraceContext parent) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    @Test
    public void shouldSendTraceContextToServer_rootSpan() throws Exception {
        this.disposableServer = HttpServer.create().port(0).handle((in, out) -> out.sendString((Publisher)Flux.just((Object)in.requestHeaders().get("b3")))).bindNow();
        Mono request = ((HttpClient.ResponseReceiver)this.httpClient.port(this.disposableServer.port()).get().uri("/")).responseContent().aggregate().asString();
        String b3SingleHeaderReadByServer = (String)request.block();
        FinishedSpan clientSpan = this.handler.takeRemoteSpan(Span.Kind.CLIENT);
        Assertions.assertThat((String)b3SingleHeaderReadByServer).isEqualTo(clientSpan.getTraceId() + "-" + clientSpan.getSpanId() + "-1");
    }

    @Test
    public void shouldRecordRequestError() {
        this.disposableServer = HttpServer.create().port(0).handle((req, resp) -> {
            throw new RuntimeException("test");
        }).bindNow();
        Mono request = ((HttpClient.ResponseReceiver)this.httpClient.port(this.disposableServer.port()).get().uri("/")).responseContent().aggregate().asString();
        Assertions.assertThatThrownBy(() -> ((Mono)request).block()).hasCauseInstanceOf(PrematureCloseException.class);
        this.handler.takeRemoteSpanWithError(Span.Kind.CLIENT);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfiguration {
        @Bean
        HttpClient reactorHttpClient() {
            return HttpClient.create();
        }
    }
}

