/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.messaging;

import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.common.AmqpServiceInfo;
import org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfig;

public class RabbitConnectionFactoryCreator
extends AbstractServiceConnectorCreator<ConnectionFactory, AmqpServiceInfo> {
    public ConnectionFactory create(AmqpServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfiguration) {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(serviceInfo.getHost());
        connectionFactory.setVirtualHost(serviceInfo.getVirtualHost());
        connectionFactory.setUsername(serviceInfo.getUserName());
        connectionFactory.setPassword(serviceInfo.getPassword());
        connectionFactory.setPort(serviceInfo.getPort());
        if (serviceConnectorConfiguration != null) {
            connectionFactory.setChannelCacheSize(((RabbitConnectionFactoryConfig)serviceConnectorConfiguration).getChannelCacheSize().intValue());
        }
        return connectionFactory;
    }
}

