/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.java;

import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.document.MongoDbFactoryConfig;
import org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfig;
import org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public abstract class AbstractCloudConfig
implements BeanFactoryAware {
    private static final String CLOUD_FACTORY_BEAN_NAME = "__cloud_factory__";
    private CloudFactory cloudFactory;
    private Cloud cloud;
    private ServiceConnectionFactory connectionFactory;

    protected CloudFactory cloudFactory() {
        return this.cloudFactory;
    }

    @Bean
    public Cloud cloud() {
        return this.cloud;
    }

    public ServiceConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    public Properties properties() {
        return this.cloud().getCloudProperties();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.cloudFactory == null) {
            try {
                this.cloudFactory = (CloudFactory)beanFactory.getBean(CloudFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.cloudFactory = new CloudFactory();
                ((SingletonBeanRegistry)beanFactory).registerSingleton(CLOUD_FACTORY_BEAN_NAME, (Object)this.cloudFactory);
            }
        }
        this.cloud = this.cloudFactory.getCloud();
        this.connectionFactory = new ServiceConnectionFactory();
    }

    public class ServiceConnectionFactory {
        public DataSource dataSource() {
            return this.dataSource((DataSourceConfig)null);
        }

        public DataSource dataSource(DataSourceConfig dataSourceConfig) {
            return (DataSource)AbstractCloudConfig.this.cloud.getSingletonServiceConnector(DataSource.class, (ServiceConnectorConfig)dataSourceConfig);
        }

        public DataSource dataSource(String serviceId) {
            return this.dataSource(serviceId, null);
        }

        public DataSource dataSource(String serviceId, DataSourceConfig dataSourceConfig) {
            return (DataSource)AbstractCloudConfig.this.cloud.getServiceConnector(serviceId, DataSource.class, (ServiceConnectorConfig)dataSourceConfig);
        }

        public MongoDbFactory mongoDbFactory() {
            return this.mongoDbFactory((MongoDbFactoryConfig)null);
        }

        public MongoDbFactory mongoDbFactory(MongoDbFactoryConfig mongoDbFactoryConfig) {
            return (MongoDbFactory)AbstractCloudConfig.this.cloud.getSingletonServiceConnector(MongoDbFactory.class, (ServiceConnectorConfig)mongoDbFactoryConfig);
        }

        public MongoDbFactory mongoDbFactory(String serviceId) {
            return this.mongoDbFactory(serviceId, null);
        }

        public MongoDbFactory mongoDbFactory(String serviceId, MongoDbFactoryConfig mongoDbFactoryConfig) {
            return (MongoDbFactory)AbstractCloudConfig.this.cloud.getServiceConnector(serviceId, MongoDbFactory.class, (ServiceConnectorConfig)mongoDbFactoryConfig);
        }

        public ConnectionFactory rabbitConnectionFactory() {
            return this.rabbitConnectionFactory((RabbitConnectionFactoryConfig)null);
        }

        public ConnectionFactory rabbitConnectionFactory(RabbitConnectionFactoryConfig rabbitConnectionFactoryConfig) {
            return (ConnectionFactory)AbstractCloudConfig.this.cloud.getSingletonServiceConnector(ConnectionFactory.class, (ServiceConnectorConfig)rabbitConnectionFactoryConfig);
        }

        public ConnectionFactory rabbitConnectionFactory(String serviceId) {
            return this.rabbitConnectionFactory(serviceId, null);
        }

        public ConnectionFactory rabbitConnectionFactory(String serviceId, RabbitConnectionFactoryConfig rabbitConnectionFactoryConfig) {
            return (ConnectionFactory)AbstractCloudConfig.this.cloud.getServiceConnector(serviceId, ConnectionFactory.class, (ServiceConnectorConfig)rabbitConnectionFactoryConfig);
        }

        public RedisConnectionFactory redisConnectionFactory() {
            return this.redisConnectionFactory((PooledServiceConnectorConfig)null);
        }

        public RedisConnectionFactory redisConnectionFactory(PooledServiceConnectorConfig redisConnectionFactoryConfig) {
            return (RedisConnectionFactory)AbstractCloudConfig.this.cloud.getSingletonServiceConnector(RedisConnectionFactory.class, (ServiceConnectorConfig)redisConnectionFactoryConfig);
        }

        public RedisConnectionFactory redisConnectionFactory(String serviceId) {
            return this.redisConnectionFactory(serviceId, null);
        }

        public RedisConnectionFactory redisConnectionFactory(String serviceId, PooledServiceConnectorConfig redisConnectionFactoryConfig) {
            return (RedisConnectionFactory)AbstractCloudConfig.this.cloud.getServiceConnector(serviceId, RedisConnectionFactory.class, (ServiceConnectorConfig)redisConnectionFactoryConfig);
        }

        public Object service() {
            return this.service(Object.class);
        }

        public <T> T service(Class<T> serviceConnectorType) {
            return (T)AbstractCloudConfig.this.cloud.getSingletonServiceConnector(serviceConnectorType, null);
        }

        public Object service(String serviceId) {
            return this.service(serviceId, Object.class);
        }

        public <T> T service(String serviceId, Class<T> serviceConnectorType) {
            return (T)AbstractCloudConfig.this.cloud.getServiceConnector(serviceId, serviceConnectorType, null);
        }
    }
}

