/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.StreamsMetadata;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.util.StringUtils;

public class InteractiveQueryService {
    private final KafkaStreamsRegistry kafkaStreamsRegistry;
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;

    public InteractiveQueryService(KafkaStreamsRegistry kafkaStreamsRegistry, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
        this.binderConfigurationProperties = binderConfigurationProperties;
    }

    public <T> T getQueryableStore(String storeName, QueryableStoreType<T> storeType) {
        for (KafkaStreams kafkaStream : this.kafkaStreamsRegistry.getKafkaStreams()) {
            try {
                Object store = kafkaStream.store(storeName, storeType);
                if (store == null) continue;
                return (T)store;
            }
            catch (InvalidStateStoreException invalidStateStoreException) {
            }
        }
        return null;
    }

    public HostInfo getCurrentHostInfo() {
        Map configuration = this.binderConfigurationProperties.getConfiguration();
        if (configuration.containsKey("application.server")) {
            String applicationServer = (String)configuration.get("application.server");
            String[] splits = StringUtils.split((String)applicationServer, (String)":");
            return new HostInfo(splits[0], Integer.valueOf(splits[1]).intValue());
        }
        return null;
    }

    public <K> HostInfo getHostInfo(String store, K key, Serializer<K> serializer) {
        StreamsMetadata streamsMetadata = this.kafkaStreamsRegistry.getKafkaStreams().stream().map(k -> Optional.ofNullable(k.metadataForKey(store, key, serializer))).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        return streamsMetadata != null ? streamsMetadata.hostInfo() : null;
    }
}

