/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kstream;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.kafka.streams.kstream.KStream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.binding.StreamListenerParameterAdapter;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.StreamListenerSetupMethodOrchestrator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class KStreamListenerSetupMethodOrchestrator
implements StreamListenerSetupMethodOrchestrator,
ApplicationContextAware {
    private ConfigurableApplicationContext applicationContext;
    private StreamListenerParameterAdapter streamListenerParameterAdapter;
    private Collection<StreamListenerResultAdapter> streamListenerResultAdapters;

    public KStreamListenerSetupMethodOrchestrator(StreamListenerParameterAdapter streamListenerParameterAdapter, Collection<StreamListenerResultAdapter> streamListenerResultAdapters) {
        this.streamListenerParameterAdapter = streamListenerParameterAdapter;
        this.streamListenerResultAdapters = streamListenerResultAdapters;
    }

    public boolean supports(Method method) {
        return this.methodParameterSuppports(method) && this.methodReturnTypeSuppports(method);
    }

    private boolean methodReturnTypeSuppports(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(KStream.class) || returnType.isArray() && returnType.getComponentType().equals(KStream.class);
    }

    private boolean methodParameterSuppports(Method method) {
        MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)0);
        Class parameterType = methodParameter.getParameterType();
        return parameterType.equals(KStream.class);
    }

    public void orchestrateStreamListenerSetupMethod(StreamListener streamListener, Method method, Object bean) {
        block8: {
            String[] methodAnnotatedOutboundNames = KStreamListenerSetupMethodOrchestrator.getOutboundBindingTargetNames(method);
            this.validateStreamListenerMethod(streamListener, method, methodAnnotatedOutboundNames);
            String methodAnnotatedInboundName = streamListener.value();
            Object[] adaptedInboundArguments = this.adaptAndRetrieveInboundArguments(method, methodAnnotatedInboundName, (ApplicationContext)this.applicationContext, new StreamListenerParameterAdapter[]{this.streamListenerParameterAdapter});
            try {
                Object result = method.invoke(bean, adaptedInboundArguments);
                if (result.getClass().isArray()) {
                    Assert.isTrue((methodAnnotatedOutboundNames.length == ((Object[])result).length ? 1 : 0) != 0, (String)"Big error");
                } else {
                    Assert.isTrue((methodAnnotatedOutboundNames.length == 1 ? 1 : 0) != 0, (String)"Big error");
                }
                if (result.getClass().isArray()) {
                    Object[] outboundKStreams = (Object[])result;
                    int i = 0;
                    block2: for (Object outboundKStream : outboundKStreams) {
                        Object targetBean = this.applicationContext.getBean(methodAnnotatedOutboundNames[i++]);
                        for (StreamListenerResultAdapter streamListenerResultAdapter : this.streamListenerResultAdapters) {
                            if (!streamListenerResultAdapter.supports(outboundKStream.getClass(), targetBean.getClass())) continue;
                            streamListenerResultAdapter.adapt(outboundKStream, targetBean);
                            continue block2;
                        }
                    }
                    break block8;
                }
                Object targetBean = this.applicationContext.getBean(methodAnnotatedOutboundNames[0]);
                for (StreamListenerResultAdapter streamListenerResultAdapter : this.streamListenerResultAdapters) {
                    if (!streamListenerResultAdapter.supports(result.getClass(), targetBean.getClass())) continue;
                    streamListenerResultAdapter.adapt(result, targetBean);
                    break;
                }
            }
            catch (Exception e) {
                throw new BeanInitializationException("Cannot setup StreamListener for " + method, (Throwable)e);
            }
        }
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    private void validateStreamListenerMethod(StreamListener streamListener, Method method, String[] methodAnnotatedOutboundNames) {
        String methodAnnotatedInboundName = streamListener.value();
        for (String s : methodAnnotatedOutboundNames) {
            if (!StringUtils.hasText((String)s)) continue;
            Assert.isTrue((boolean)this.isDeclarativeOutput(method, s), (String)"Method must be declarative");
        }
        if (StringUtils.hasText((String)methodAnnotatedInboundName)) {
            int methodArgumentsLength = method.getParameterTypes().length;
            for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
                MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
                Assert.isTrue((boolean)this.isDeclarativeInput(methodAnnotatedInboundName, methodParameter), (String)"Method must be declarative");
            }
        }
    }

    private boolean isDeclarativeOutput(Method m, String targetBeanName) {
        Class<?> returnType = m.getReturnType();
        if (returnType.isArray()) {
            Class targetBeanClass = this.applicationContext.getType(targetBeanName);
            boolean declarative = this.streamListenerResultAdapters.stream().anyMatch(slpa -> slpa.supports(returnType.getComponentType(), targetBeanClass));
            return declarative;
        }
        Class targetBeanClass = this.applicationContext.getType(targetBeanName);
        boolean declarative = this.streamListenerResultAdapters.stream().anyMatch(slpa -> slpa.supports(returnType, targetBeanClass));
        return declarative;
    }

    private boolean isDeclarativeInput(String targetBeanName, MethodParameter methodParameter) {
        if (!methodParameter.getParameterType().isAssignableFrom(Object.class) && this.applicationContext.containsBean(targetBeanName)) {
            Class targetBeanClass = this.applicationContext.getType(targetBeanName);
            return this.streamListenerParameterAdapter.supports(targetBeanClass, methodParameter);
        }
        return false;
    }

    private static String[] getOutboundBindingTargetNames(Method method) {
        SendTo sendTo = (SendTo)AnnotationUtils.findAnnotation((Method)method, SendTo.class);
        if (sendTo != null) {
            Assert.isTrue((!ObjectUtils.isEmpty((Object[])sendTo.value()) ? 1 : 0) != 0, (String)"At least one output must be specified");
            Assert.isTrue((sendTo.value().length >= 1 ? 1 : 0) != 0, (String)"At least one outbound destination need to be provided.");
            return sendTo.value();
        }
        return null;
    }
}

