/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class ConnectionFactorySettings {
    @Value(value="${spring.rabbitmq.useSSL:false}")
    private boolean useSSL;
    @Value(value="${spring.rabbitmq.sslProperties:}")
    private Resource sslPropertiesLocation;

    @Bean
    public ConnectionFactory rabbitConnectionFactory(RabbitProperties config, com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory) throws Exception {
        CachingConnectionFactory factory = new CachingConnectionFactory(rabbitConnectionFactory);
        factory.setAddresses(config.getAddresses());
        if (config.getHost() != null) {
            factory.setHost(config.getHost());
            factory.setPort(config.getPort());
        }
        if (config.getUsername() != null) {
            factory.setUsername(config.getUsername());
        }
        if (config.getPassword() != null) {
            factory.setPassword(config.getPassword());
        }
        if (config.getVirtualHost() != null) {
            factory.setVirtualHost(config.getVirtualHost());
        }
        return factory;
    }

    @Bean
    public RabbitConnectionFactoryBean rabbitFactory() {
        RabbitConnectionFactoryBean rabbitConnectionFactoryBean = new RabbitConnectionFactoryBean();
        rabbitConnectionFactoryBean.setUseSSL(this.useSSL);
        rabbitConnectionFactoryBean.setSslPropertiesLocation(this.sslPropertiesLocation);
        return rabbitConnectionFactoryBean;
    }

    @Configuration
    @ConditionalOnMissingBean(value={RabbitProperties.class})
    @EnableConfigurationProperties(value={RabbitProperties.class})
    public static class RabbitPropertiesLoader {
    }
}

